/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.api.ConnectionFailureException;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.hadoop.HCatLauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.dependency.URIHandlerException;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.service.HCatAccessorException;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class HCatURIHandler
implements URIHandler {
    private Set<String> supportedSchemes;
    private Map<String, URIHandler.DependencyType> dependencyTypes;
    private List<Class<?>> classesToShip;

    @Override
    public void init(Configuration conf) {
        this.dependencyTypes = new HashMap<String, URIHandler.DependencyType>();
        this.supportedSchemes = new HashSet<String>();
        String[] schemes = conf.getStrings("oozie.service.URIHandlerService.uri.handler." + this.getClass().getSimpleName() + ".supported.schemes", new String[]{"hcat"});
        this.supportedSchemes.addAll(Arrays.asList(schemes));
        this.classesToShip = new HCatLauncherURIHandler().getClassesForLauncher();
    }

    @Override
    public Set<String> getSupportedSchemes() {
        return this.supportedSchemes;
    }

    @Override
    public Class<? extends LauncherURIHandler> getLauncherURIHandlerClass() {
        return HCatLauncherURIHandler.class;
    }

    @Override
    public List<Class<?>> getClassesForLauncher() {
        return this.classesToShip;
    }

    @Override
    public URIHandler.DependencyType getDependencyType(URI uri) throws URIHandlerException {
        URIHandler.DependencyType depType = URIHandler.DependencyType.PULL;
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (hcatService != null && (depType = this.dependencyTypes.get(uri.getAuthority())) == null) {
            depType = hcatService.isKnownPublisher(uri) ? URIHandler.DependencyType.PUSH : URIHandler.DependencyType.PULL;
            this.dependencyTypes.put(uri.getAuthority(), depType);
        }
        return depType;
    }

    @Override
    public void registerForNotification(URI uri, Configuration conf, String user, String actionID) throws URIHandlerException {
        HCatURI hcatURI;
        try {
            hcatURI = new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0906, uri, e);
        }
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (!hcatService.isRegisteredForNotification(hcatURI)) {
            HCatClient client = this.getHCatClient(uri, conf);
            try {
                String topic = client.getMessageBusTopicName(hcatURI.getDb(), hcatURI.getTable());
                if (topic == null) {
                    return;
                }
                hcatService.registerForNotification(hcatURI, topic, new HCatMessageHandler(uri.getAuthority()));
            }
            catch (HCatException e) {
                throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
            }
            finally {
                this.closeQuietly(client, null, true);
            }
        }
        PartitionDependencyManagerService pdmService = Services.get().get(PartitionDependencyManagerService.class);
        pdmService.addMissingDependency(hcatURI, actionID);
    }

    @Override
    public boolean unregisterFromNotification(URI uri, String actionID) {
        HCatURI hcatURI;
        try {
            hcatURI = new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        PartitionDependencyManagerService pdmService = Services.get().get(PartitionDependencyManagerService.class);
        return pdmService.removeMissingDependency(hcatURI, actionID);
    }

    @Override
    public URIHandler.Context getContext(URI uri, Configuration conf, String user, boolean readOnly) throws URIHandlerException {
        HCatContext context = null;
        if (readOnly) {
            HCatClient client = this.getHCatClient(uri, conf);
            context = new HCatContext(conf, user, client);
        } else {
            HCatClientWithToken client = this.getHCatClient(uri, conf, user);
            context = new HCatContext(conf, user, client);
        }
        return context;
    }

    @Override
    public boolean exists(URI uri, URIHandler.Context context) throws URIHandlerException {
        HCatClient client = ((HCatContext)context).getHCatClient();
        return this.exists(uri, client, false);
    }

    @Override
    public boolean exists(URI uri, Configuration conf, String user) throws URIHandlerException {
        HCatClient client = this.getHCatClient(uri, conf);
        return this.exists(uri, client, true);
    }

    @Override
    public void delete(URI uri, URIHandler.Context context) throws URIHandlerException {
        HCatClient client = ((HCatContext)context).getHCatClient();
        try {
            HCatURI hcatUri = new HCatURI(uri);
            if (!hcatUri.getPartitionMap().isEmpty()) {
                client.dropPartitions(hcatUri.getDb(), hcatUri.getTable(), hcatUri.getPartitionMap(), true);
            } else {
                client.dropTable(hcatUri.getDb(), hcatUri.getTable(), true);
            }
        }
        catch (URISyntaxException e) {
            throw new HCatAccessorException(ErrorCode.E1501, e);
        }
        catch (HCatException e) {
            throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete(URI uri, Configuration conf, String user) throws URIHandlerException {
        HCatClientWithToken client = null;
        HCatClient hCatClient = null;
        try {
            HCatURI hcatUri = new HCatURI(uri);
            client = this.getHCatClient(uri, conf, user);
            hCatClient = client.getHCatClient();
            if (!hcatUri.getPartitionMap().isEmpty()) {
                hCatClient.dropPartitions(hcatUri.getDb(), hcatUri.getTable(), hcatUri.getPartitionMap(), true);
            } else {
                hCatClient.dropTable(hcatUri.getDb(), hcatUri.getTable(), true);
            }
            this.closeQuietly(hCatClient, client != null ? client.getDelegationToken() : null, true);
            return;
        }
        catch (URISyntaxException e) {
            try {
                throw new HCatAccessorException(ErrorCode.E1501, e);
                catch (HCatException e2) {
                    throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e2});
                }
            }
            catch (Throwable throwable) {
                this.closeQuietly(hCatClient, client != null ? client.getDelegationToken() : null, true);
                throw throwable;
            }
        }
    }

    @Override
    public String getURIWithDoneFlag(String uri, String doneFlag) throws URIHandlerException {
        return uri;
    }

    @Override
    public String getURIWithoutDoneFlag(String uri, String doneFlag) throws URIHandlerException {
        return uri;
    }

    @Override
    public void validate(String uri) throws URIHandlerException {
        try {
            new HCatURI(uri);
        }
        catch (URISyntaxException e) {
            throw new URIHandlerException(ErrorCode.E0906, uri, e);
        }
    }

    @Override
    public void destroy() {
    }

    private HiveConf getHiveConf(URI uri, Configuration conf) throws HCatAccessorException {
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        if (hcatService.getHCatConf() != null) {
            conf = hcatService.getHCatConf();
        }
        HiveConf hiveConf = new HiveConf(conf, this.getClass());
        String serverURI = this.getMetastoreConnectURI(uri);
        if (!serverURI.equals("")) {
            hiveConf.set("hive.metastore.local", "false");
        }
        hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, serverURI);
        return hiveConf;
    }

    private HCatClient getHCatClient(URI uri, Configuration conf) throws HCatAccessorException {
        HiveConf hiveConf = this.getHiveConf(uri, conf);
        try {
            XLog.getLog(HCatURIHandler.class).info("Creating HCatClient for login_user [{0}] and server [{1}] ", UserGroupInformation.getLoginUser(), hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname));
            return HCatClient.create((Configuration)hiveConf);
        }
        catch (HCatException e) {
            throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
        }
        catch (IOException e) {
            throw new HCatAccessorException(ErrorCode.E1501, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HCatClientWithToken getHCatClient(URI uri, Configuration conf, String user) throws HCatAccessorException {
        final HiveConf hiveConf = this.getHiveConf(uri, conf);
        String delegationToken = null;
        try {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            hiveConf.set("hive.metastore.token.signature", "HCatTokenSignature");
            if (hiveConf.getBoolean(HiveConf.ConfVars.METASTORE_USE_THRIFT_SASL.varname, false)) {
                try (HCatClient tokenClient = null;){
                    tokenClient = HCatClient.create((Configuration)hiveConf);
                    delegationToken = tokenClient.getDelegationToken(user, UserGroupInformation.getLoginUser().getUserName());
                    Token token = new Token();
                    token.decodeFromUrlString(delegationToken);
                    token.setService(new Text(hiveConf.get("hive.metastore.token.signature")));
                    ugi.addToken(token);
                }
            }
            XLog.getLog(HCatURIHandler.class).info("Creating HCatClient for user [{0}] login_user [{1}] and server [{2}] ", user, UserGroupInformation.getLoginUser(), hiveConf.get(HiveConf.ConfVars.METASTOREURIS.varname));
            HCatClient hcatClient = (HCatClient)ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<HCatClient>(){

                @Override
                public HCatClient run() throws Exception {
                    HCatClient client = HCatClient.create((Configuration)hiveConf);
                    return client;
                }
            });
            HCatClientWithToken clientWithToken = new HCatClientWithToken(hcatClient, delegationToken);
            return clientWithToken;
        }
        catch (IOException e) {
            throw new HCatAccessorException(ErrorCode.E1501, e.getMessage());
        }
        catch (Exception e) {
            throw new HCatAccessorException(ErrorCode.E1501, e.getMessage());
        }
    }

    private String getMetastoreConnectURI(URI uri) throws HCatAccessorException {
        String metastoreURI;
        if (uri.getAuthority().equals("unittest-local")) {
            metastoreURI = "";
        } else {
            try {
                HCatURI hCatURI = new HCatURI(uri.toString());
                metastoreURI = hCatURI.getServerEndPointWithScheme("thrift");
            }
            catch (URISyntaxException e) {
                throw new HCatAccessorException(ErrorCode.E0902, e);
            }
        }
        return metastoreURI;
    }

    private boolean exists(URI uri, HCatClient client, boolean closeClient) throws HCatAccessorException {
        try {
            List tables;
            List partitions;
            HCatURI hcatURI = new HCatURI(uri.toString());
            boolean flag = !hcatURI.getPartitionMap().isEmpty() ? (partitions = client.getPartitions(hcatURI.getDb(), hcatURI.getTable(), hcatURI.getPartitionMap())) != null && !partitions.isEmpty() : (tables = client.listTableNamesByPattern(hcatURI.getDb(), hcatURI.getTable())) != null && !tables.isEmpty();
            boolean bl = flag;
            return bl;
        }
        catch (ConnectionFailureException e) {
            throw new HCatAccessorException(ErrorCode.E1501, new Object[]{e});
        }
        catch (HCatException e) {
            throw new HCatAccessorException(ErrorCode.E0902, new Object[]{e});
        }
        catch (URISyntaxException e) {
            throw new HCatAccessorException(ErrorCode.E0902, e);
        }
        finally {
            this.closeQuietly(client, null, closeClient);
        }
    }

    private void closeQuietly(HCatClient client, String delegationToken, boolean close) {
        if (close && client != null) {
            try {
                if (delegationToken != null && !delegationToken.isEmpty()) {
                    client.cancelDelegationToken(delegationToken);
                }
                client.close();
            }
            catch (Exception ignore) {
                XLog.getLog(HCatURIHandler.class).warn((Object)"Error closing hcat client", ignore);
            }
        }
    }

    static class HCatContext
    extends URIHandler.Context {
        private HCatClient hcatClient;
        private String delegationToken;

        public HCatContext(Configuration conf, String user, HCatClient hcatClient) {
            super(conf, user);
            this.hcatClient = hcatClient;
        }

        public HCatContext(Configuration conf, String user, HCatClientWithToken hcatClient) {
            super(conf, user);
            this.hcatClient = hcatClient.getHCatClient();
            this.delegationToken = hcatClient.getDelegationToken();
        }

        public HCatClient getHCatClient() {
            return this.hcatClient;
        }

        public String getDelegationToken() {
            return this.delegationToken;
        }

        @Override
        public void destroy() {
            try {
                if (this.delegationToken != null && !this.delegationToken.isEmpty()) {
                    this.hcatClient.cancelDelegationToken(this.delegationToken);
                }
                this.delegationToken = null;
            }
            catch (Exception ignore) {
                XLog.getLog(HCatContext.class).warn((Object)"Error cancelling delegation token", ignore);
            }
            try {
                this.hcatClient.close();
            }
            catch (Exception ignore) {
                XLog.getLog(HCatContext.class).warn((Object)"Error closing hcat client", ignore);
            }
        }
    }

    class HCatClientWithToken {
        private HCatClient hcatClient;
        private String token;

        public HCatClientWithToken(HCatClient client, String delegationToken) {
            this.hcatClient = client;
            this.token = delegationToken;
        }

        public HCatClient getHCatClient() {
            return this.hcatClient;
        }

        public String getDelegationToken() {
            return this.token;
        }
    }
}

