/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency.hcat;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.dependency.hcat.HCatDependencyCache;
import org.apache.oozie.dependency.hcat.WaitingAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class SimpleHCatDependencyCache
implements HCatDependencyCache {
    private static XLog LOG = XLog.getLog(SimpleHCatDependencyCache.class);
    private static String DELIMITER = ";";
    public static final String USE_CANONICAL_HOSTNAME = "oozie.service.HCatAccessorService.jms.use.canonical.hostname";
    private boolean useCanonicalHostName = false;
    private ConcurrentMap<String, ConcurrentMap<String, Map<String, Collection<WaitingAction>>>> missingDeps;
    private ConcurrentMap<String, Collection<String>> availableDeps;
    private ConcurrentMap<String, ConcurrentMap<String, Collection<String>>> actionPartitionMap;

    @Override
    public void init(Configuration conf) {
        this.missingDeps = new ConcurrentHashMap<String, ConcurrentMap<String, Map<String, Collection<WaitingAction>>>>();
        this.availableDeps = new ConcurrentHashMap<String, Collection<String>>();
        this.actionPartitionMap = new ConcurrentHashMap<String, ConcurrentMap<String, Collection<String>>>();
        this.useCanonicalHostName = ConfigurationService.getBoolean(USE_CANONICAL_HOSTNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMissingDependency(HCatURI hcatURI, String actionID) {
        ConcurrentMap existingPartMap;
        ConcurrentMap<String, ArrayList<String>> partitionMap;
        ConcurrentMap existingMap;
        String tableKey = this.canonicalizeHostname(hcatURI.getServer()) + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        ConcurrentMap partKeyPatterns = (ConcurrentHashMap)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null && (existingMap = (ConcurrentMap)this.missingDeps.putIfAbsent(tableKey, partKeyPatterns = new ConcurrentHashMap())) != null) {
            partKeyPatterns = existingMap;
        }
        if ((partitionMap = (ConcurrentHashMap)this.actionPartitionMap.get(actionID)) == null && (existingPartMap = (ConcurrentMap)this.actionPartitionMap.putIfAbsent(actionID, partitionMap = new ConcurrentHashMap())) != null) {
            partitionMap = existingPartMap;
        }
        ConcurrentHashMap concurrentHashMap = partitionMap;
        synchronized (concurrentHashMap) {
            ArrayList<String> partKeys = (ArrayList<String>)partitionMap.get(tableKey);
            if (partKeys == null) {
                partKeys = new ArrayList<String>();
            }
            partKeys.add(partKey);
            partitionMap.put(tableKey, partKeys);
        }
        concurrentHashMap = partKeyPatterns;
        synchronized (concurrentHashMap) {
            HashSet<WaitingAction> waitingActions;
            this.missingDeps.put(tableKey, partKeyPatterns);
            HashMap<String, HashSet<WaitingAction>> partValues = (HashMap<String, HashSet<WaitingAction>>)partKeyPatterns.get(partKey);
            if (partValues == null) {
                partValues = new HashMap<String, HashSet<WaitingAction>>();
                partKeyPatterns.put(partKey, partValues);
            }
            if ((waitingActions = (HashSet<WaitingAction>)partValues.get(partVal)) == null) {
                waitingActions = new HashSet<WaitingAction>();
                partValues.put(partVal, waitingActions);
            }
            waitingActions.add(new WaitingAction(actionID, hcatURI.toURIString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMissingDependency(HCatURI hcatURI, String actionID) {
        Map map;
        String tableKey = this.canonicalizeHostname(hcatURI.getServer()) + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            LOG.warn("Remove missing dependency - Missing table entry - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            return false;
        }
        ConcurrentMap partitionMap = (ConcurrentMap)this.actionPartitionMap.get(actionID);
        if (partitionMap != null) {
            map = partitionMap;
            synchronized (map) {
                Collection partKeys = (Collection)partitionMap.get(tableKey);
                if (partKeys != null) {
                    partKeys.remove(partKey);
                }
                if (partKeys.size() == 0) {
                    partitionMap.remove(tableKey);
                }
                if (partitionMap.size() == 0) {
                    this.actionPartitionMap.remove(actionID);
                }
            }
        }
        map = partKeyPatterns;
        synchronized (map) {
            Map partValues = (Map)partKeyPatterns.get(partKey);
            if (partValues == null) {
                LOG.warn("Remove missing dependency - Missing partition pattern - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
                return false;
            }
            Collection waitingActions = (Collection)partValues.get(partVal);
            if (waitingActions == null) {
                LOG.warn("Remove missing dependency - Missing partition value - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
                return false;
            }
            boolean removed = waitingActions.remove(new WaitingAction(actionID, hcatURI.toURIString()));
            if (!removed) {
                LOG.warn("Remove missing dependency - Missing action ID - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            }
            if (waitingActions.isEmpty()) {
                partValues.remove(partVal);
                if (partValues.isEmpty()) {
                    partKeyPatterns.remove(partKey);
                }
                if (partKeyPatterns.isEmpty()) {
                    this.missingDeps.remove(tableKey);
                    HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
                    hcatService.unregisterFromNotification(hcatURI);
                }
            }
            return removed;
        }
    }

    @Override
    public Collection<String> getWaitingActions(HCatURI hcatURI) {
        String tableKey = this.canonicalizeHostname(hcatURI.getServer()) + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            return null;
        }
        Map partValues = (Map)partKeyPatterns.get(partKey);
        if (partValues == null) {
            return null;
        }
        Collection waitingActions = (Collection)partValues.get(partVal);
        if (waitingActions == null) {
            return null;
        }
        ArrayList<String> actionIDs = new ArrayList<String>();
        URI uri = hcatURI.getURI();
        String uriString = null;
        try {
            uriString = new URI(uri.getScheme(), this.canonicalizeHostname(uri.getAuthority()), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            uriString = hcatURI.toURIString();
        }
        for (WaitingAction action : waitingActions) {
            if (!action.getDependencyURI().equals(uriString)) continue;
            actionIDs.add(action.getActionID());
        }
        return actionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> markDependencyAvailable(String server, String db, String table, Map<String, String> partitions) {
        String tableKey = this.canonicalizeHostname(server) + DELIMITER + db + DELIMITER + table;
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            LOG.warn("Got partition available notification for " + tableKey + ". Unexpected and should not be listening to topic. Unregistering topic");
            HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
            hcatService.unregisterFromNotification(server, db, table);
            return null;
        }
        HashSet<String> actionsWithAvailDep = new HashSet<String>();
        ArrayList partKeysToRemove = new ArrayList();
        StringBuilder partValSB = new StringBuilder();
        Map map = partKeyPatterns;
        synchronized (map) {
            for (Map.Entry entry : partKeyPatterns.entrySet()) {
                String[] partKeys = ((String)entry.getKey()).split(DELIMITER);
                partValSB.setLength(0);
                for (String key : partKeys) {
                    partValSB.append(partitions.get(key)).append(DELIMITER);
                }
                partValSB.setLength(partValSB.length() - 1);
                Map partValues = (Map)entry.getValue();
                String partVal = partValSB.toString();
                Collection wActions = (Collection)((Map)entry.getValue()).get(partVal);
                if (wActions == null) continue;
                for (WaitingAction wAction : wActions) {
                    Collection existing;
                    String actionID = wAction.getActionID();
                    actionsWithAvailDep.add(actionID);
                    Collection<String> depURIs = (ArrayList<String>)this.availableDeps.get(actionID);
                    if (depURIs == null && (existing = (Collection)this.availableDeps.putIfAbsent(actionID, depURIs = new ArrayList<String>())) != null) {
                        depURIs = existing;
                    }
                    ArrayList<String> arrayList = depURIs;
                    synchronized (arrayList) {
                        depURIs.add(wAction.getDependencyURI());
                        this.availableDeps.put(actionID, depURIs);
                    }
                }
                partValues.remove(partVal);
                if (!partValues.isEmpty()) continue;
                partKeysToRemove.add(entry.getKey());
            }
            for (String partKey : partKeysToRemove) {
                partKeyPatterns.remove(partKey);
            }
            if (partKeyPatterns.isEmpty()) {
                this.missingDeps.remove(tableKey);
                HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
                hcatService.unregisterFromNotification(server, db, table);
            }
        }
        return actionsWithAvailDep;
    }

    @Override
    public Collection<String> getAvailableDependencyURIs(String actionID) {
        ArrayList available = (ArrayList)this.availableDeps.get(actionID);
        if (available != null) {
            available = new ArrayList(available);
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAvailableDependencyURIs(String actionID, Collection<String> dependencyURIs) {
        if (!this.availableDeps.containsKey(actionID)) {
            return false;
        }
        Collection availList = (Collection)this.availableDeps.get(actionID);
        if (!availList.removeAll(dependencyURIs)) {
            return false;
        }
        Collection collection = availList;
        synchronized (collection) {
            if (availList.isEmpty()) {
                this.availableDeps.remove(actionID);
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.missingDeps.clear();
        this.availableDeps.clear();
    }

    private HCatURI removePartitions(String coordActionId, Collection<String> partKeys, Map<String, Map<String, Collection<WaitingAction>>> partKeyPatterns) {
        HCatURI hcatUri = null;
        for (String partKey : partKeys) {
            Map<String, Collection<WaitingAction>> partValues = partKeyPatterns.get(partKey);
            Iterator<String> partValItr = partValues.keySet().iterator();
            while (partValItr.hasNext()) {
                String partVal = partValItr.next();
                Collection<WaitingAction> waitingActions = partValues.get(partVal);
                if (waitingActions != null) {
                    Iterator<WaitingAction> waitItr = waitingActions.iterator();
                    while (waitItr.hasNext()) {
                        WaitingAction waction = waitItr.next();
                        if (!coordActionId.contains(waction.getActionID())) continue;
                        waitItr.remove();
                        if (hcatUri != null) continue;
                        try {
                            hcatUri = new HCatURI(waction.getDependencyURI());
                        }
                        catch (URISyntaxException e) {}
                    }
                }
                if (waitingActions.size() != 0) continue;
                partValItr.remove();
            }
            if (partValues.size() != 0) continue;
            partKeyPatterns.remove(partKey);
        }
        return hcatUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNonWaitingCoordActions(Set<String> coordActions) {
        HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
        for (String coordActionId : coordActions) {
            LOG.info("Removing non waiting coord action {0} from partition dependency map", coordActionId);
            ConcurrentMap<String, ConcurrentMap<String, Collection<String>>> concurrentMap = this.actionPartitionMap;
            synchronized (concurrentMap) {
                Map partitionMap = (Map)this.actionPartitionMap.get(coordActionId);
                if (partitionMap != null) {
                    Iterator tableItr = partitionMap.keySet().iterator();
                    while (tableItr.hasNext()) {
                        String tableKey = (String)tableItr.next();
                        HCatURI hcatUri = null;
                        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
                        if (partKeyPatterns == null) continue;
                        Map map = partKeyPatterns;
                        synchronized (map) {
                            Collection partKeys = (Collection)partitionMap.get(tableKey);
                            if (partKeys != null) {
                                hcatUri = this.removePartitions(coordActionId, partKeys, partKeyPatterns);
                            }
                        }
                        if (partKeyPatterns.size() != 0) continue;
                        tableItr.remove();
                        if (hcatUri == null) continue;
                        hcatService.unregisterFromNotification(hcatUri);
                    }
                }
                this.actionPartitionMap.remove(coordActionId);
            }
        }
    }

    @Override
    public void removeCoordActionWithDependenciesAvailable(String coordAction) {
        this.actionPartitionMap.remove(coordAction);
    }

    public String canonicalizeHostname(String name) {
        return SimpleHCatDependencyCache.canonicalizeHostname(name, this.useCanonicalHostName);
    }

    public static String canonicalizeHostname(String name, boolean useCanonicalHostName) {
        if (useCanonicalHostName) {
            String hostname = name;
            String port = null;
            if (name.contains(":")) {
                hostname = name.split(":")[0];
                port = name.split(":")[1];
            }
            try {
                InetAddress address = InetAddress.getByName(hostname);
                String canonicalHostName = address.getCanonicalHostName();
                if (null != port) {
                    return canonicalHostName + ":" + port;
                }
                return canonicalHostName;
            }
            catch (IOException ex) {
                LOG.error(ex);
                return name;
            }
        }
        return name;
    }

    private static class SortedPKV {
        private StringBuilder partKeys = new StringBuilder();
        private StringBuilder partVals = new StringBuilder();

        public SortedPKV(Map<String, String> partitions) {
            ArrayList<String> keys = new ArrayList<String>(partitions.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.partKeys.append(key).append(DELIMITER);
                this.partVals.append(partitions.get(key)).append(DELIMITER);
            }
            this.partKeys.setLength(this.partKeys.length() - 1);
            this.partVals.setLength(this.partVals.length() - 1);
        }

        public String getPartKeys() {
            return this.partKeys.toString();
        }

        public String getPartVals() {
            return this.partVals.toString();
        }
    }
}

