/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Map;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

@Deprecated
public class InstrumentationService
implements Service {
    private static final String JVM_INSTRUMENTATION_GROUP = "jvm";
    public static final String CONF_PREFIX = "oozie.service.InstrumentationService.";
    public static final String CONF_LOGGING_INTERVAL = "oozie.service.InstrumentationService.logging.interval";
    private final XLog log = XLog.getLog("oozieinstrumentation");
    protected static Instrumentation instrumentation = null;
    private static boolean isEnabled = false;

    @Override
    public void init(Services services) throws ServiceException {
        Instrumentation instr = new Instrumentation();
        int interval = ConfigurationService.getInt(services.getConf(), CONF_LOGGING_INTERVAL);
        this.initLogging(services, instr, interval);
        instr.addVariable(JVM_INSTRUMENTATION_GROUP, "free.memory", new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        instr.addVariable(JVM_INSTRUMENTATION_GROUP, "max.memory", new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        instr.addVariable(JVM_INSTRUMENTATION_GROUP, "total.memory", new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
        instrumentation = instr;
        isEnabled = true;
    }

    void initLogging(Services services, final Instrumentation instr, int interval) throws ServiceException {
        this.log.info("*********** Startup ***********");
        this.log.info("Java System Properties: {E}{0}", this.mapToString(instr.getJavaSystemProperties()));
        this.log.info("OS Env: {E}{0}", this.mapToString(instr.getOSEnv()));
        SchedulerService schedulerService = services.get(SchedulerService.class);
        if (schedulerService != null) {
            instr.setScheduler(schedulerService.getScheduler());
            if (interval > 0) {
                Runnable instrumentationLogger = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            InstrumentationService.this.log.info("\n" + instr.toString());
                        }
                        catch (Throwable ex) {
                            InstrumentationService.this.log.warn((Object)"Instrumentation logging error", ex);
                        }
                    }
                };
                schedulerService.schedule(instrumentationLogger, (long)interval, (long)interval, SchedulerService.Unit.SEC);
            }
        } else {
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), "SchedulerService unavailable");
        }
    }

    private String mapToString(Map<String, String> map) {
        String E = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append("    ").append(entry.getKey()).append(" = ").append(entry.getValue()).append(E);
        }
        return sb.toString();
    }

    @Override
    public void destroy() {
        isEnabled = false;
        instrumentation = null;
    }

    @Override
    public Class<? extends Service> getInterface() {
        return InstrumentationService.class;
    }

    public Instrumentation get() {
        return instrumentation;
    }

    public static boolean isEnabled() {
        return isEnabled;
    }
}

