/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.SLAEventBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.client.rest.JsonSLAEvent;
import org.apache.oozie.command.SkipCommitFaultInjection;
import org.apache.oozie.compression.CodecFactory;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.db.OperationRetryHandler;
import org.apache.oozie.util.db.PersistenceExceptionSubclassFilterRetryPredicate;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.persistence.InvalidStateException;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;

public class JPAService
implements Service,
Instrumentable {
    private static final String INSTRUMENTATION_GROUP_JPA = "jpa";
    public static final long DEFAULT_INITIAL_WAIT_TIME = 100L;
    public static final long DEFAULT_MAX_WAIT_TIME = 30000L;
    public static final int DEFAULT_MAX_RETRY_COUNT = 1;
    public static final String CONF_DB_SCHEMA = "oozie.db.schema.name";
    public static final String CONF_PREFIX = "oozie.service.JPAService.";
    public static final String CONF_URL = "oozie.service.JPAService.jdbc.url";
    public static final String CONF_DRIVER = "oozie.service.JPAService.jdbc.driver";
    public static final String CONF_USERNAME = "oozie.service.JPAService.jdbc.username";
    public static final String CONF_PASSWORD = "oozie.service.JPAService.jdbc.password";
    public static final String CONF_CONN_DATA_SOURCE = "oozie.service.JPAService.connection.data.source";
    public static final String CONF_CONN_PROPERTIES = "oozie.service.JPAService.connection.properties";
    public static final String CONF_MAX_ACTIVE_CONN = "oozie.service.JPAService.pool.max.active.conn";
    public static final String CONF_CREATE_DB_SCHEMA = "oozie.service.JPAService.create.db.schema";
    public static final String CONF_VALIDATE_DB_CONN = "oozie.service.JPAService.validate.db.connection";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL = "oozie.service.JPAService.validate.db.connection.eviction.interval";
    public static final String CONF_VALIDATE_DB_CONN_EVICTION_NUM = "oozie.service.JPAService.validate.db.connection.eviction.num";
    public static final String CONF_OPENJPA_BROKER_IMPL = "oozie.service.JPAService.openjpa.BrokerImpl";
    public static final String INITIAL_WAIT_TIME = "oozie.service.JPAService.retry.initial-wait-time.ms";
    public static final String MAX_WAIT_TIME = "oozie.service.JPAService.maximum-wait-time.ms";
    public static final String MAX_RETRY_COUNT = "oozie.service.JPAService.retry.max-retries";
    public static final String SKIP_COMMIT_FAULT_INJECTION_CLASS = SkipCommitFaultInjection.class.getName();
    private EntityManagerFactory factory;
    private Instrumentation instr;
    private static XLog LOG;
    private OperationRetryHandler retryHandler;

    @Override
    public Class<? extends Service> getInterface() {
        return JPAService.class;
    }

    @Override
    public void instrument(Instrumentation instr) {
        this.instr = instr;
        final BasicDataSource dataSource = this.getBasicDataSource();
        if (dataSource != null) {
            instr.addSampler("jdbc", "connections.active", 60, 1, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return dataSource.getNumActive();
                }
            });
            instr.addSampler("jdbc", "connections.idle", 60, 1, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return dataSource.getNumIdle();
                }
            });
        }
    }

    private BasicDataSource getBasicDataSource() {
        BasicDataSource basicDataSource = null;
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.factory;
        Object connectionFactory = spi.getConfiguration().getConnectionFactory();
        if (connectionFactory instanceof DecoratingDataSource) {
            DecoratingDataSource decoratingDataSource = (DecoratingDataSource)connectionFactory;
            basicDataSource = (BasicDataSource)decoratingDataSource.getInnermostDelegate();
        } else if (connectionFactory instanceof BasicDataSource) {
            basicDataSource = (BasicDataSource)connectionFactory;
        }
        return basicDataSource;
    }

    @Override
    public void init(Services services) throws ServiceException {
        LOG = XLog.getLog(JPAService.class);
        Configuration conf = services.getConf();
        String dbSchema = ConfigurationService.get(conf, CONF_DB_SCHEMA);
        String url = ConfigurationService.get(conf, CONF_URL);
        String driver = ConfigurationService.get(conf, CONF_DRIVER);
        String user = ConfigurationService.get(conf, CONF_USERNAME);
        String password = ConfigurationService.getPassword(conf, CONF_PASSWORD).trim();
        String maxConn = ConfigurationService.get(conf, CONF_MAX_ACTIVE_CONN).trim();
        String dataSource = ConfigurationService.get(conf, CONF_CONN_DATA_SOURCE);
        String connPropsConfig = ConfigurationService.get(conf, CONF_CONN_PROPERTIES);
        String brokerImplConfig = ConfigurationService.get(conf, CONF_OPENJPA_BROKER_IMPL);
        boolean autoSchemaCreation = ConfigurationService.getBoolean(conf, CONF_CREATE_DB_SCHEMA);
        boolean validateDbConn = ConfigurationService.getBoolean(conf, CONF_VALIDATE_DB_CONN);
        String evictionInterval = ConfigurationService.get(conf, CONF_VALIDATE_DB_CONN_EVICTION_INTERVAL).trim();
        String evictionNum = ConfigurationService.get(conf, CONF_VALIDATE_DB_CONN_EVICTION_NUM).trim();
        if (!url.startsWith("jdbc:")) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, must start with 'jdbc:'");
        }
        String dbType = url.substring("jdbc:".length());
        if (dbType.indexOf(":") <= 0) {
            throw new ServiceException(ErrorCode.E0608, url, "invalid JDBC URL, missing vendor 'jdbc:[VENDOR]:...'");
        }
        dbType = dbType.substring(0, dbType.indexOf(":"));
        String persistentUnit = "oozie-" + dbType;
        String ormFile = "META-INF/" + persistentUnit + "-orm.xml";
        try {
            IOUtils.getResourceAsStream(ormFile, -1);
        }
        catch (IOException ex) {
            throw new ServiceException(ErrorCode.E0609, dbType, ormFile);
        }
        if (url.startsWith("jdbc:mysql:replication")) {
            url = "\"".concat(url).concat("\"");
            LOG.info("A jdbc replication url is provided. Url: [{0}]", url);
        }
        String connProps = "DriverClassName={0},Url={1},MaxActive={2}";
        connProps = MessageFormat.format(connProps, driver, url, maxConn);
        Properties props = new Properties();
        if (autoSchemaCreation) {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
            props.setProperty("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=true)");
        } else if (validateDbConn) {
            String interval = "timeBetweenEvictionRunsMillis=" + evictionInterval;
            String num = "numTestsPerEvictionRun=" + evictionNum;
            connProps = connProps + ",TestOnBorrow=true,TestOnReturn=true,TestWhileIdle=true," + interval + "," + num;
            connProps = connProps + ",ValidationQuery=select count(*) from VALIDATE_CONN";
            connProps = MessageFormat.format(connProps, dbSchema);
        } else {
            connProps = connProps + ",TestOnBorrow=false,TestOnReturn=false,TestWhileIdle=false";
        }
        if (connPropsConfig != null) {
            connProps = connProps + "," + connPropsConfig;
        }
        props.setProperty("openjpa.ConnectionProperties", connProps);
        props.setProperty("openjpa.ConnectionPassword", password);
        props.setProperty("openjpa.ConnectionUserName", user);
        props.setProperty("openjpa.ConnectionDriverName", dataSource);
        if (!StringUtils.isEmpty((String)brokerImplConfig)) {
            props.setProperty("openjpa.BrokerImpl", brokerImplConfig);
            LOG.info("Setting openjpa.BrokerImpl to {0}", brokerImplConfig);
        }
        this.initRetryHandler();
        this.factory = Persistence.createEntityManagerFactory((String)persistentUnit, (Map)props);
        EntityManager entityManager = this.getEntityManager();
        this.findRetrying(entityManager, WorkflowActionBean.class, 1);
        this.findRetrying(entityManager, WorkflowJobBean.class, 1);
        this.findRetrying(entityManager, CoordinatorActionBean.class, 1);
        this.findRetrying(entityManager, CoordinatorJobBean.class, 1);
        this.findRetrying(entityManager, SLAEventBean.class, 1);
        this.findRetrying(entityManager, JsonSLAEvent.class, 1);
        this.findRetrying(entityManager, BundleActionBean.class, 1);
        this.findRetrying(entityManager, BundleJobBean.class, 1);
        this.findRetrying(entityManager, SLARegistrationBean.class, 1);
        this.findRetrying(entityManager, SLASummaryBean.class, 1);
        LOG.info(1, "All entities initialized", new Object[0]);
        entityManager.getTransaction().begin();
        OpenJPAEntityManagerFactorySPI spi = (OpenJPAEntityManagerFactorySPI)this.factory;
        String logMsg = spi.getConfiguration().getConnectionProperties().replaceAll("Password=.*?,", "Password=***,");
        LOG.info("JPA configuration: {0}", logMsg);
        entityManager.getTransaction().commit();
        entityManager.close();
        try {
            CodecFactory.initialize(conf);
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E0100, this.getClass().getName(), ex);
        }
    }

    private void initRetryHandler() {
        long initialWaitTime = ConfigurationService.getInt(INITIAL_WAIT_TIME, 100);
        long maxWaitTime = ConfigurationService.getInt(MAX_WAIT_TIME, 30000);
        int maxRetryCount = ConfigurationService.getInt(MAX_RETRY_COUNT, 1);
        LOG.info(1, "Failing database operations will be retried {0} times, with an initial sleep time of {1} ms,max sleep time {2} ms", maxRetryCount, initialWaitTime, maxWaitTime);
        this.retryHandler = new OperationRetryHandler(maxRetryCount, initialWaitTime, maxWaitTime, new PersistenceExceptionSubclassFilterRetryPredicate());
    }

    private void findRetrying(final EntityManager entityManager, final Class entityClass, final int primaryKey) throws ServiceException {
        try {
            this.retryHandler.executeWithRetry(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (!entityManager.getTransaction().isActive()) {
                        entityManager.getTransaction().begin();
                    }
                    entityManager.find(entityClass, (Object)primaryKey);
                    if (entityManager.getTransaction().isActive()) {
                        entityManager.getTransaction().commit();
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new ServiceException(ErrorCode.E0603, e);
        }
    }

    @Override
    public void destroy() {
        if (this.factory != null && this.factory.isOpen()) {
            try {
                this.factory.close();
            }
            catch (InvalidStateException ise) {
                LOG.warn("Cannot close EntityManagerFactory. [ise.message={0}]", ise.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T execute(final JPAExecutor<T> executor) throws JPAExecutorException {
        Object v;
        final EntityManager em = this.getEntityManager();
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing JPAExecutor [{0}]", executor.getName());
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, executor.getName(), 1L);
            }
            cron.start();
            v = this.retryHandler.executeWithRetry(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    if (!em.getTransaction().isActive()) {
                        em.getTransaction().begin();
                    }
                    Object t = executor.execute(em);
                    JPAService.this.checkAndCommit(em.getTransaction());
                    return t;
                }
            });
            cron.stop();
            if (this.instr != null) {
                this.instr.addCron(INSTRUMENTATION_GROUP_JPA, executor.getName(), cron);
            }
        }
        catch (Exception e) {
            try {
                throw this.getTargetException(e);
            }
            catch (Throwable throwable) {
                cron.stop();
                if (this.instr != null) {
                    this.instr.addCron(INSTRUMENTATION_GROUP_JPA, executor.getName(), cron);
                }
                try {
                    if (em.getTransaction().isActive()) {
                        LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                        em.getTransaction().rollback();
                    }
                }
                catch (Exception ex) {
                    LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                try {
                    if (em.isOpen()) {
                        em.close();
                        throw throwable;
                    }
                    LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
                    throw throwable;
                }
                catch (Exception ex) {
                    LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
                }
                throw throwable;
            }
        }
        try {
            if (em.getTransaction().isActive()) {
                LOG.warn("JPAExecutor [{0}] ended with an active transaction, rolling back", executor.getName());
                em.getTransaction().rollback();
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not check/rollback transaction after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        try {
            if (em.isOpen()) {
                em.close();
                return (T)v;
            }
            LOG.warn("JPAExecutor [{0}] closed the EntityManager, it should not!", executor.getName());
            return (T)v;
        }
        catch (Exception ex) {
            LOG.warn("Could not close EntityManager after JPAExecutor [{0}], {1}", executor.getName(), ex.getMessage(), ex);
        }
        return (T)v;
    }

    private void checkAndCommit(EntityTransaction tx) throws JPAExecutorException {
        if (tx.isActive()) {
            if (FaultInjection.isActive(SKIP_COMMIT_FAULT_INJECTION_CLASS)) {
                throw new JPAExecutorException(ErrorCode.E0603, "Skipping Commit for Failover Testing");
            }
            tx.commit();
        }
    }

    public int executeUpdate(String namedQueryName, final Query query, final EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Update/Delete Query [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            int n = this.retryHandler.executeWithRetry(new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    if (!em.getTransaction().isActive()) {
                        em.getTransaction().begin();
                    }
                    int ret = query.executeUpdate();
                    JPAService.this.checkAndCommit(em.getTransaction());
                    return ret;
                }
            });
            return n;
        }
        catch (Exception e) {
            throw this.getTargetException(e);
        }
        finally {
            this.processFinally(em, cron, namedQueryName, true);
        }
    }

    private void processFinally(EntityManager em, Instrumentation.Cron cron, String name, boolean checkActive) {
        cron.stop();
        if (this.instr != null) {
            this.instr.addCron(INSTRUMENTATION_GROUP_JPA, name, cron);
        }
        if (checkActive) {
            try {
                if (em.getTransaction().isActive()) {
                    LOG.warn("[{0}] ended with an active transaction, rolling back", name);
                    em.getTransaction().rollback();
                }
            }
            catch (Exception ex) {
                LOG.warn("Could not check/rollback transaction after [{0}], {1}", name, ex.getMessage(), ex);
            }
        }
        try {
            if (em.isOpen()) {
                em.close();
            } else {
                LOG.warn("[{0}] closed the EntityManager, it should not!", name);
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not close EntityManager after [{0}], {1}", name, ex.getMessage(), ex);
        }
    }

    public void executeBatchInsertUpdateDelete(final Collection<JsonBean> insertBeans, final List<QueryEntry> updateQueryList, final Collection<JsonBean> deleteBeans, final EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Queries in Batch");
            cron.start();
            this.retryHandler.executeWithRetry(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    if (em.getTransaction().isActive()) {
                        try {
                            em.getTransaction().rollback();
                        }
                        catch (Exception e) {
                            LOG.warn("Rollback failed - ignoring");
                        }
                    }
                    em.getTransaction().begin();
                    if (CollectionUtils.isNotEmpty((Collection)updateQueryList)) {
                        for (QueryEntry q : updateQueryList) {
                            if (JPAService.this.instr != null) {
                                JPAService.this.instr.incr(JPAService.INSTRUMENTATION_GROUP_JPA, ((Enum)q.getQueryName()).name(), 1L);
                            }
                            q.getQuery().executeUpdate();
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)insertBeans)) {
                        for (JsonBean bean : insertBeans) {
                            em.persist((Object)bean);
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)deleteBeans)) {
                        for (JsonBean bean : deleteBeans) {
                            em.remove(em.merge((Object)bean));
                        }
                    }
                    JPAService.this.checkAndCommit(em.getTransaction());
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw this.getTargetException(e);
        }
        finally {
            this.processFinally(em, cron, "batchqueryexecutor", true);
        }
    }

    public Object executeGet(String namedQueryName, final Query query, EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Select Query to Get a Single row  [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            Object object = this.retryHandler.executeWithRetry(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object obj = null;
                    try {
                        obj = query.getSingleResult();
                    }
                    catch (NoResultException e) {
                        LOG.info("No results found");
                    }
                    return obj;
                }
            });
            return object;
        }
        catch (Exception e) {
            throw this.getTargetException(e);
        }
        finally {
            this.processFinally(em, cron, namedQueryName, false);
        }
    }

    public List<?> executeGetList(String namedQueryName, final Query query, EntityManager em) throws JPAExecutorException {
        Instrumentation.Cron cron = new Instrumentation.Cron();
        try {
            LOG.trace("Executing Select Query to Get Multiple Rows [{0}]", namedQueryName);
            if (this.instr != null) {
                this.instr.incr(INSTRUMENTATION_GROUP_JPA, namedQueryName, 1L);
            }
            cron.start();
            List list = (List)this.retryHandler.executeWithRetry(new Callable<List<?>>(){

                @Override
                public List<?> call() throws Exception {
                    List resultList = null;
                    try {
                        resultList = query.getResultList();
                    }
                    catch (NoResultException e) {
                        LOG.info("No results found");
                    }
                    return resultList;
                }
            });
            return list;
        }
        catch (Exception e) {
            throw this.getTargetException(e);
        }
        finally {
            this.processFinally(em, cron, namedQueryName, false);
        }
    }

    public EntityManager getEntityManager() {
        return this.factory.createEntityManager();
    }

    private JPAExecutorException getTargetException(Exception e) {
        if (e instanceof JPAExecutorException) {
            return (JPAExecutorException)e;
        }
        return new JPAExecutorException(ErrorCode.E0603, e.getMessage());
    }

    public static class QueryEntry<E extends Enum<E>> {
        E namedQuery;
        Query query;

        public QueryEntry(E namedQuery, Query query) {
            this.namedQuery = namedQuery;
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }

        public E getQueryName() {
            return this.namedQuery;
        }
    }
}

