/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XLog;

public class CallbackServlet
extends JsonRestServlet {
    private static final String INSTRUMENTATION_NAME = "callback";
    private static final JsonRestServlet.ResourceInfo RESOURCE_INFO = new JsonRestServlet.ResourceInfo("", Arrays.asList("POST", "GET"), Collections.emptyList());
    public static final String CONF_MAX_DATA_LEN = "oozie.servlet.CallbackServlet.max.data.len";
    private static int maxDataLen;
    private XLog log = null;

    public CallbackServlet() {
        super(INSTRUMENTATION_NAME, RESOURCE_INFO);
    }

    public void init() {
        maxDataLen = ConfigurationService.getInt(CONF_MAX_DATA_LEN);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        CallbackService callbackService = Services.get().get(CallbackService.class);
        if (!callbackService.isValid(queryString)) {
            throw new XServletException(400, ErrorCode.E0402, queryString);
        }
        String actionId = callbackService.getActionId(queryString);
        if (actionId == null) {
            throw new XServletException(400, ErrorCode.E0402, queryString);
        }
        this.log = XLog.getLog(((Object)((Object)this)).getClass());
        this.setLogInfo(actionId);
        this.log.debug("Received a CallbackServlet.doGet() with query string " + queryString);
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getSystemDagEngine();
        try {
            this.log.info(1, "callback for action [{0}]", actionId);
            dagEngine.processCallback(actionId, callbackService.getExternalStatus(queryString), null);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        CallbackService callbackService = Services.get().get(CallbackService.class);
        if (!callbackService.isValid(queryString)) {
            throw new XServletException(400, ErrorCode.E0402, queryString);
        }
        String actionId = callbackService.getActionId(queryString);
        if (actionId == null) {
            throw new XServletException(400, ErrorCode.E0402, queryString);
        }
        this.log = XLog.getLog(((Object)((Object)this)).getClass());
        this.setLogInfo(actionId);
        this.log.debug("Received a CallbackServlet.doPost() with query string " + queryString);
        this.validateContentType(request, "text/plain");
        try {
            this.log.info(1, "callback for action [{0}]", actionId);
            String data = IOUtils.getReaderAsString(request.getReader(), maxDataLen);
            Properties props = PropertiesUtils.stringToProperties(data);
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getSystemDagEngine();
            dagEngine.processCallback(actionId, callbackService.getExternalStatus(queryString), props);
        }
        catch (IOException ex) {
            if (ex.getMessage().startsWith("stream exceeds limit")) {
                throw new XServletException(400, ErrorCode.E0403, "data too long");
            }
            throw ex;
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }
}

