/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.OozieJsonFactory;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobsServlet;
import org.apache.oozie.servlet.XServletException;
import org.json.simple.JSONObject;

public class V0JobsServlet
extends BaseJobsServlet {
    private static final String INSTRUMENTATION_NAME = "v0jobs";

    public V0JobsServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JSONObject submitJob(HttpServletRequest request, Configuration conf) throws XServletException, IOException {
        JSONObject json = new JSONObject();
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user);
            String id = dagEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    @Override
    protected JSONObject getJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException, IOException {
        JSONObject json = new JSONObject();
        try {
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
            String jobId = dagEngine.getJobIdForExternalId(externalId);
            json.put((Object)"id", (Object)jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    @Override
    protected JSONObject getJobs(HttpServletRequest request) throws XServletException, IOException {
        JSONObject json;
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request));
            WorkflowsInfo jobs = dagEngine.getJobs(filter, start, len);
            json = OozieJsonFactory.getWFJSONObject(jobs, "GMT");
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    @Override
    protected JSONObject killJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new UnsupportedOperationException("method not implemented in V0 API");
    }

    @Override
    protected JSONObject suspendJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new UnsupportedOperationException("method not implemented in V0 API");
    }

    @Override
    protected JSONObject resumeJobs(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        throw new UnsupportedOperationException("method not implemented in V0 API");
    }
}

