/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.Color;
import guru.nidi.graphviz.attribute.RankDir;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Engine;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.Rasterizer;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.Graph;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.Node;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.graph.GraphRenderer;
import org.apache.oozie.util.graph.WorkflowActionNode;

public class GraphvizRenderer
implements GraphRenderer {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    private static final long GRAPHVIZ_TIMEOUT_SECONDS = ConfigurationService.getLong("oozie.graphviz.timeout.seconds");
    private Graph graphvizGraph = ((Graph)Factory.graph().generalAttr().with((Attributes)RankDir.TOP_TO_BOTTOM)).directed();
    private final Map<String, Node> graphvizNodes = new LinkedHashMap<String, Node>();
    private final Multimap<String, String> edges = ArrayListMultimap.create();
    private int arcCount = 0;

    @Override
    public void addNode(WorkflowActionNode node) {
        Shape shape = this.getShape(node.getType());
        Color color = this.getColor(node.getStatus());
        Node graphvizNode = (Node)((Node)Factory.node((String)node.getName()).with((Attributes)shape)).with((Attributes)color);
        this.graphvizNodes.put(node.getName(), graphvizNode);
    }

    private Shape getShape(String type) {
        Shape shape;
        switch (type) {
            case "start": {
                shape = Shape.CIRCLE;
                break;
            }
            case "end": {
                shape = Shape.DOUBLE_CIRCLE;
                break;
            }
            case "kill": {
                shape = Shape.OCTAGON;
                break;
            }
            case "decision": {
                shape = Shape.DIAMOND;
                break;
            }
            case "fork": {
                shape = Shape.TRIANGLE;
                break;
            }
            case "join": {
                shape = Shape.INV_TRIANGLE;
                break;
            }
            default: {
                shape = Shape.RECTANGLE;
            }
        }
        return shape;
    }

    private Color getColor(WorkflowAction.Status status) {
        Color color;
        if (status == null) {
            return Color.BLACK;
        }
        switch (status) {
            case PREP: 
            case USER_RETRY: 
            case START_RETRY: 
            case START_MANUAL: {
                color = Color.GREY;
                break;
            }
            case RUNNING: 
            case END_RETRY: 
            case END_MANUAL: {
                color = Color.YELLOW;
                break;
            }
            case OK: 
            case DONE: {
                color = Color.GREEN;
                break;
            }
            case ERROR: 
            case FAILED: 
            case KILLED: {
                color = Color.RED;
                break;
            }
            default: {
                color = Color.BLACK;
            }
        }
        return color;
    }

    private Node createOrGetGraphvizNode(WorkflowActionNode node) {
        if (this.graphvizNodes.containsKey(node.getName())) {
            return this.graphvizNodes.get(node.getName());
        }
        this.addNode(node);
        return this.graphvizNodes.get(node.getName());
    }

    @Override
    public void addEdge(WorkflowActionNode parent, WorkflowActionNode child) {
        if (this.edges.containsEntry((Object)parent.getName(), (Object)child.getName())) {
            return;
        }
        Node graphvizParent = this.createOrGetGraphvizNode(parent);
        graphvizParent = graphvizParent.link(new LinkTarget[]{Factory.to((Node)this.createOrGetGraphvizNode(child)).with((Attributes)this.calculateEdgeColor(child.getStatus()))});
        this.graphvizNodes.put(parent.getName(), graphvizParent);
        this.edges.put((Object)parent.getName(), (Object)child.getName());
        ++this.arcCount;
    }

    private Color calculateEdgeColor(WorkflowAction.Status childStatus) {
        if (childStatus == null) {
            return Color.BLACK;
        }
        if (childStatus.equals((Object)WorkflowAction.Status.RUNNING)) {
            return Color.GREEN;
        }
        return this.getColor(childStatus);
    }

    @Override
    public void persist(WorkflowActionNode node) {
        Node graphvizNode = this.graphvizNodes.get(node.getName());
        this.graphvizGraph = this.graphvizGraph.with(new LinkSource[]{graphvizNode});
    }

    @Override
    public BufferedImage renderPng() {
        Future<BufferedImage> pngFuture = EXECUTOR_SERVICE.submit(new PngRenderer());
        try {
            return pngFuture.get(GRAPHVIZ_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private int calculateHeight(int arcCount) {
        return Math.min(arcCount * 100, 2000);
    }

    @Override
    public String renderDot() {
        return this.graphvizGraph.toString();
    }

    @Override
    public String renderSvg() {
        Future<String> svgFuture = EXECUTOR_SERVICE.submit(new SvgRenderer());
        try {
            return svgFuture.get(GRAPHVIZ_TIMEOUT_SECONDS, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    private Graphviz newGraphviz() {
        return Graphviz.fromGraph((Graph)this.graphvizGraph).rasterizer(Rasterizer.BATIK).engine(Engine.DOT).height(this.calculateHeight(this.arcCount));
    }

    private class SvgRenderer
    implements Callable<String> {
        private SvgRenderer() {
        }

        @Override
        public String call() throws Exception {
            Graphviz graphviz = GraphvizRenderer.this.newGraphviz();
            return graphviz.render(Format.SVG).toString();
        }
    }

    private class PngRenderer
    implements Callable<BufferedImage> {
        private PngRenderer() {
        }

        @Override
        public BufferedImage call() throws Exception {
            Graphviz graphviz = GraphvizRenderer.this.newGraphviz();
            return graphviz.render(Format.PNG).toImage();
        }
    }
}

