/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.examples.pi.Combinable;
import org.apache.hadoop.examples.pi.Container;
import org.apache.hadoop.examples.pi.SummationWritable;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Summation;
import org.apache.hadoop.io.Writable;

public class TaskResult
implements Container<Summation>,
Combinable<TaskResult>,
Writable {
    private Summation sigma;
    private long duration;

    public TaskResult() {
    }

    TaskResult(Summation sigma, long duration) {
        this.sigma = sigma;
        this.duration = duration;
    }

    @Override
    public Summation getElement() {
        return this.sigma;
    }

    long getDuration() {
        return this.duration;
    }

    @Override
    public int compareTo(TaskResult that) {
        return this.sigma.compareTo(that.sigma);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof TaskResult) {
            TaskResult that = (TaskResult)obj;
            return this.compareTo(that) == 0;
        }
        throw new IllegalArgumentException(obj == null ? "obj == null" : "obj.getClass()=" + obj.getClass());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TaskResult combine(TaskResult that) {
        Summation s = this.sigma.combine(that.sigma);
        return s == null ? null : new TaskResult(s, this.duration + that.duration);
    }

    public void readFields(DataInput in) throws IOException {
        this.sigma = SummationWritable.read(in);
        this.duration = in.readLong();
    }

    public void write(DataOutput out) throws IOException {
        SummationWritable.write(this.sigma, out);
        out.writeLong(this.duration);
    }

    public String toString() {
        return "sigma=" + this.sigma + ", duration=" + this.duration + "(" + Util.millis2String(this.duration) + ")";
    }

    public static TaskResult valueOf(String s) {
        int i = 0;
        int j = s.indexOf(", duration=");
        if (j < 0) {
            throw new IllegalArgumentException("i=" + i + ", j=" + j + " < 0, s=" + s);
        }
        Summation sigma = Summation.valueOf(Util.parseStringVariable("sigma", s.substring(i, j)));
        i = j + 2;
        if ((j = s.indexOf("(", i)) < 0) {
            throw new IllegalArgumentException("i=" + i + ", j=" + j + " < 0, s=" + s);
        }
        long duration = Util.parseLongVariable("duration", s.substring(i, j));
        return new TaskResult(sigma, duration);
    }
}

