# vim: tabstop=4 shiftwidth=4 softtabstop=4

# Copyright (c) 2013 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
# implied.
# See the License for the specific language governing permissions and
# limitations under the License.
from savannadashboard.api import base


class JobBinaryInternal(base.Resource):
    resource_name = 'Job Binary Internal'
    defaults = {}


class JobBinaryInternalManager(base.ResourceManager):
    resource_class = JobBinaryInternal

    def create(self, name, data):
        resp = self.api.client.put('/job-binary-internals/%s' % name, data)
        if resp.status_code != 202:
            self._raise_api_exception(resp)
        return resp.json()

    def list(self):
        return self._list('/job-binary-internals', 'binaries')

    def get(self, job_binary_id):
        return self._get('/job-binary-internals/%s' % job_binary_id,
                         'resource')

    def delete(self, job_binary_id):
        self._delete('/job-binary-internals/%s' % job_binary_id)
