# flake8: noqa
# fmt: off

from . import base

list_rules = (
    base.Rule(
        name="context_is_admin",
        check_str=("role:admin"),
        description="No description",
    ),
    base.Rule(
        name="admin_or_owner",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="No description",
    ),
    base.Rule(
        name="admin_api",
        check_str=("rule:context_is_admin"),
        description="No description",
    ),
    base.Rule(
        name="deny_everybody",
        check_str=("!"),
        description="Default rule for deny everybody.",
    ),
    base.APIRule(
        name="container:create",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Create a new container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:create:runtime",
        check_str=("rule:context_is_admin"),
        description="Create a new container with specified runtime.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:create:privileged",
        check_str=("rule:deny_everybody"),
        description="Create a new privileged container.Warning: the privileged container has a big security risk so be caution if you want to enable this feature",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:create:requested_destination",
        check_str=("rule:context_is_admin"),
        description="Create a container on the requested compute host.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:create:image_pull_policy",
        check_str=("rule:context_is_admin"),
        description="Create a new container with specified image pull policy.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:delete",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Delete a container.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:delete_all_projects",
        check_str=("rule:context_is_admin"),
        description="Delete a container from all projects.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:delete_force",
        check_str=("rule:context_is_admin"),
        description="Forcibly delete a container.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Retrieve the details of a specific container.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one:host",
        check_str=("rule:context_is_admin"),
        description="Retrieve the host field of containers.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}, {"method": "GET", "path": "/v1/containers"}, {"method": "POST", "path": "/v1/containers"}, {"method": "PATCH", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one:image_pull_policy",
        check_str=("rule:context_is_admin"),
        description="Retrieve the image_pull_policy field of containers.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}, {"method": "GET", "path": "/v1/containers"}, {"method": "POST", "path": "/v1/containers"}, {"method": "PATCH", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one:privileged",
        check_str=("rule:context_is_admin"),
        description="Retrieve the privileged field of containers.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}, {"method": "GET", "path": "/v1/containers"}, {"method": "POST", "path": "/v1/containers"}, {"method": "PATCH", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one:runtime",
        check_str=("rule:context_is_admin"),
        description="Retrieve the runtime field of containers.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}, {"method": "GET", "path": "/v1/containers"}, {"method": "POST", "path": "/v1/containers"}, {"method": "PATCH", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_one_all_projects",
        check_str=("rule:context_is_admin"),
        description="Retrieve the details of a specific container from all projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:get_all",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Retrieve the details of all containers.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:get_all_all_projects",
        check_str=("rule:context_is_admin"),
        description="Retrieve the details of all containers across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="container:update",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Update a container.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/containers/{container_ident}"}],
    ),
    base.APIRule(
        name="container:start",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Start a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/start"}],
    ),
    base.APIRule(
        name="container:stop",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Stop a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/stop"}],
    ),
    base.APIRule(
        name="container:reboot",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Reboot a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/reboot"}],
    ),
    base.APIRule(
        name="container:pause",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Pause a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/pause"}],
    ),
    base.APIRule(
        name="container:unpause",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Unpause a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/unpause"}],
    ),
    base.APIRule(
        name="container:logs",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Get the log of a container",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/logs"}],
    ),
    base.APIRule(
        name="container:execute",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Execute command in a running container",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/execute"}],
    ),
    base.APIRule(
        name="container:execute_resize",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Resize the TTY used by an execute command.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/execute_resize"}],
    ),
    base.APIRule(
        name="container:kill",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Kill a running container",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/kill"}],
    ),
    base.APIRule(
        name="container:rename",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Rename a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/rename"}],
    ),
    base.APIRule(
        name="container:attach",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Attach to a running container",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/attach"}],
    ),
    base.APIRule(
        name="container:resize",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Resize a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/resize"}],
    ),
    base.APIRule(
        name="container:top",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Display the running processes inside the container.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/top"}],
    ),
    base.APIRule(
        name="container:get_archive",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Get a tar archive of a path of container.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/get_archive"}],
    ),
    base.APIRule(
        name="container:put_archive",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Put a tar archive to be extracted to a path of container",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/containers/{container_ident}/put_archive"}],
    ),
    base.APIRule(
        name="container:stats",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Display the statistics of a container",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/stats"}],
    ),
    base.APIRule(
        name="container:commit",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Commit a container",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/commit"}],
    ),
    base.APIRule(
        name="container:add_security_group",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Add a security group to a specific container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/add_security_group"}],
    ),
    base.APIRule(
        name="container:network_detach",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Detach a network from a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/network_detach"}],
    ),
    base.APIRule(
        name="container:network_attach",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Attach a network from a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/network_attach"}],
    ),
    base.APIRule(
        name="container:remove_security_group",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Remove security group from a specific container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/remove_security_group"}],
    ),
    base.APIRule(
        name="container:rebuild",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Rebuild a container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/rebuild"}],
    ),
    base.APIRule(
        name="container:resize_container",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Resize an existing  container.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers/{container_ident}/resize_container"}],
    ),
    base.APIRule(
        name="image:pull",
        check_str=("rule:context_is_admin"),
        description="Pull an image.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/images"}],
    ),
    base.APIRule(
        name="image:get_all",
        check_str=("rule:context_is_admin"),
        description="Print a list of available images.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/images"}],
    ),
    base.APIRule(
        name="image:get_one",
        check_str=("rule:context_is_admin"),
        description="Retrieve the details of a specific image.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/images/{image_id}"}],
    ),
    base.APIRule(
        name="image:search",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Search an image.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/images/{image_ident}/search"}],
    ),
    base.APIRule(
        name="image:delete",
        check_str=("rule:context_is_admin"),
        description="Delete an image.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/images/{image_ident}"}],
    ),
    base.APIRule(
        name="zun-service:delete",
        check_str=("rule:context_is_admin"),
        description="Delete a service.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/services"}],
    ),
    base.APIRule(
        name="zun-service:disable",
        check_str=("rule:context_is_admin"),
        description="Disable a service.",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/services/disable"}],
    ),
    base.APIRule(
        name="zun-service:enable",
        check_str=("rule:context_is_admin"),
        description="Enable a service.",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/services/enable"}],
    ),
    base.APIRule(
        name="zun-service:force_down",
        check_str=("rule:context_is_admin"),
        description="Forcibly shutdown a service.",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/services/force_down"}],
    ),
    base.APIRule(
        name="zun-service:get_all",
        check_str=("rule:context_is_admin"),
        description="Show the status of a service.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/services"}],
    ),
    base.APIRule(
        name="host:get_all",
        check_str=("rule:context_is_admin"),
        description="List all compute hosts.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/hosts"}],
    ),
    base.APIRule(
        name="host:get",
        check_str=("rule:context_is_admin"),
        description="Show the details of a specific compute host.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/hosts/{host_ident}"}],
    ),
    base.APIRule(
        name="capsule:create",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Create a capsule",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/capsules/"}],
    ),
    base.APIRule(
        name="capsule:delete",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Delete a capsule",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/capsules/{capsule_ident}"}],
    ),
    base.APIRule(
        name="capsule:delete_all_projects",
        check_str=("rule:context_is_admin"),
        description="Delete a container in any project.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/capsules/{capsule_ident}"}],
    ),
    base.APIRule(
        name="capsule:get",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Retrieve the details of a capsule.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/capsules/{capsule_ident}"}],
    ),
    base.APIRule(
        name="capsule:get:host",
        check_str=("rule:context_is_admin"),
        description="Retrieve the host field of a capsule.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/capsules/{capsule_ident}"}, {"method": "GET", "path": "/v1/capsules"}, {"method": "POST", "path": "/v1/capsules"}],
    ),
    base.APIRule(
        name="capsule:get_one_all_projects",
        check_str=("rule:context_is_admin"),
        description="Retrieve the details of a capsule in any project.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/capsules/{capsule_ident}"}],
    ),
    base.APIRule(
        name="capsule:get_all",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="List all capsules.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/capsules/"}],
    ),
    base.APIRule(
        name="capsule:get_all_all_projects",
        check_str=("rule:context_is_admin"),
        description="List all capsules across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/capsules/"}],
    ),
    base.APIRule(
        name="network:attach_external_network",
        check_str=("role:admin"),
        description="Attach an unshared external network to a container",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/containers"}],
    ),
    base.APIRule(
        name="network:create",
        check_str=("role:admin"),
        description="Create a network",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/networks"}],
    ),
    base.APIRule(
        name="network:delete",
        check_str=("role:admin"),
        description="Delete a network",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/networks"}],
    ),
    base.APIRule(
        name="container:actions",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="List actions and show action details for a container",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/container_actions/"}, {"method": "GET", "path": "/v1/containers/{container_ident}/container_actions/{request_id}"}],
    ),
    base.APIRule(
        name="container:action:events",
        check_str=("rule:context_is_admin"),
        description="Add events details in action details for a container.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/containers/{container_ident}/container_actions/{request_id}"}],
    ),
    base.APIRule(
        name="availability_zones:get_all",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="List availability zone",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/availability_zones"}],
    ),
    base.APIRule(
        name="quota:update",
        check_str=("rule:context_is_admin"),
        description="Update quotas for a project",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/quotas/{project_id}"}],
    ),
    base.APIRule(
        name="quota:delete",
        check_str=("rule:context_is_admin"),
        description="Delete quotas for a project",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/quotas/{project_id}"}],
    ),
    base.APIRule(
        name="quota:get",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Get quotas for a project",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/quotas/{project_id}"}],
    ),
    base.APIRule(
        name="quota:get_default",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Get default quotas for a project",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/quotas/defaults"}],
    ),
    base.APIRule(
        name="quota_class:update",
        check_str=("rule:context_is_admin"),
        description="Update quotas for specific quota class",
        scope_types=["project"],
        operations=[{"method": "PUT", "path": "/v1/quota_classes/{quota_class_name}"}],
    ),
    base.APIRule(
        name="quota_class:get",
        check_str=("rule:context_is_admin"),
        description="List quotas for specific quota class",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/quota_classes/{quota_class_name}"}],
    ),
    base.APIRule(
        name="registry:create",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Create a new registry.",
        scope_types=["project"],
        operations=[{"method": "POST", "path": "/v1/registries"}],
    ),
    base.APIRule(
        name="registry:delete",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Delete a registry.",
        scope_types=["project"],
        operations=[{"method": "DELETE", "path": "/v1/registries/{registry_ident}"}],
    ),
    base.APIRule(
        name="registry:get_one",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Retrieve the details of a specific registry.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/registries/{registry_ident}"}],
    ),
    base.APIRule(
        name="registry:get_all",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Retrieve the details of all registries.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/registries"}],
    ),
    base.APIRule(
        name="registry:get_all_all_projects",
        check_str=("rule:context_is_admin"),
        description="Retrieve the details of all registries across projects.",
        scope_types=["project"],
        operations=[{"method": "GET", "path": "/v1/registries"}],
    ),
    base.APIRule(
        name="registry:update",
        check_str=("is_admin:True or project_id:%(project_id)s"),
        description="Update a registry.",
        scope_types=["project"],
        operations=[{"method": "PATCH", "path": "/v1/registries/{registry_ident}"}],
    ),
)

__all__ = ("list_rules",)
