# Copyright 2022 99cloud
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# flake8: noqa
# fmt: off

from skyline_apiserver.schemas.policy_manager import Operation

from . import base

list_rules = (
    base.Rule(
        name="admin",
        check_str=("role:admin or is_admin:True"),
        description="No description",
    ),
    base.Rule(
        name="owner",
        check_str=("project_id:%(tenant_id)s"),
        description="No description",
    ),
    base.Rule(
        name="admin_or_owner",
        check_str=("rule:admin or rule:owner"),
        description="No description",
    ),
    base.Rule(
        name="default",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="all_tenants",
        check_str=("role:admin"),
        description="Action on all tenants.",
    ),
    base.Rule(
        name="edit_managed_records",
        check_str=("role:admin"),
        description="Edit managed records.",
    ),
    base.Rule(
        name="use_low_ttl",
        check_str=("role:admin"),
        description="Use low TTL.",
    ),
    base.Rule(
        name="use_sudo",
        check_str=("role:admin"),
        description="Accept sudo from user to tenant.",
    ),
    base.Rule(
        name="hard_delete",
        check_str=("role:admin"),
        description="Clean backend resources associated with zone",
    ),
    base.Rule(
        name="create_pool",
        check_str=("role:admin"),
        description="Create pool.",
    ),
    base.Rule(
        name="update_pool",
        check_str=("role:admin"),
        description="Update pool.",
    ),
    base.Rule(
        name="delete_pool",
        check_str=("role:admin"),
        description="Delete pool.",
    ),
    base.Rule(
        name="count_records",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="get_recordsets",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="find_recordset",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="List a Recordset in a Zone",
    ),
    base.Rule(
        name="count_recordset",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Count recordsets",
    ),
    base.Rule(
        name="update_service_status",
        check_str=("role:admin"),
        description="No description",
    ),
    base.Rule(
        name="find_project_zone_share",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Check the can query for a specific projects shares.",
    ),
    base.Rule(
        name="find_tenants",
        check_str=("role:admin"),
        description="Find all Tenants.",
    ),
    base.Rule(
        name="get_tenant",
        check_str=("role:admin"),
        description="Get all Tenants.",
    ),
    base.Rule(
        name="count_tenants",
        check_str=("role:admin"),
        description="Count tenants",
    ),
    base.Rule(
        name="get_zones",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="get_zone_servers",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="count_zones",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="count_zones_pending_notify",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.Rule(
        name="purge_zones",
        check_str=("role:admin"),
        description="No description",
    ),
    base.Rule(
        name="get_zone_transfer_request_detailed",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="No description",
    ),
    base.APIRule(
        name="create_blacklist",
        check_str=("role:admin"),
        description="Create blacklist.",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/blacklists")],
    ),
    base.APIRule(
        name="find_blacklists",
        check_str=("role:admin"),
        description="Find blacklists.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/blacklists")],
    ),
    base.APIRule(
        name="get_blacklist",
        check_str=("role:admin"),
        description="Get blacklist.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/blacklists/{blacklist_id}")],
    ),
    base.APIRule(
        name="update_blacklist",
        check_str=("role:admin"),
        description="Update blacklist.",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/blacklists/{blacklist_id}")],
    ),
    base.APIRule(
        name="delete_blacklist",
        check_str=("role:admin"),
        description="Delete blacklist.",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/blacklists/{blacklist_id}")],
    ),
    base.APIRule(
        name="use_blacklisted_zone",
        check_str=("role:admin"),
        description="Allowed bypass the blacklist.",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones")],
    ),
    base.APIRule(
        name="find_pools",
        check_str=("role:admin"),
        description="Find pool.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/pools")],
    ),
    base.APIRule(
        name="find_pool",
        check_str=("role:admin"),
        description="Find pools.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/pools")],
    ),
    base.APIRule(
        name="get_pool",
        check_str=("role:admin"),
        description="Get pool.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/pools/{pool_id}")],
    ),
    base.APIRule(
        name="zone_create_forced_pool",
        check_str=("role:admin"),
        description="load and set the pool to the one provided in the Zone attributes.",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones")],
    ),
    base.APIRule(
        name="get_quotas",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s) or (True:%(all_tenants)s and role:reader)"),
        description="View Current Project's Quotas.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/quotas")],
    ),
    base.APIRule(
        name="set_quota",
        check_str=("role:admin"),
        description="Set Quotas.",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/quotas/{project_id}")],
    ),
    base.APIRule(
        name="reset_quotas",
        check_str=("role:admin"),
        description="Reset Quotas.",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/quotas/{project_id}")],
    ),
    base.APIRule(
        name="find_records",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Find records.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/reverse/floatingips/{region}:{floatingip_id}"), Operation(method="GET", path="/v2/reverse/floatingips")],
    ),
    base.APIRule(
        name="create_recordset",
        check_str=("(role:member and project_id:%(project_id)s) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('SECONDARY':%(zone_type)s) or (\"True\":%(zone_shared)s) and ('PRIMARY':%(zone_type)s)"),
        description="Create Recordset",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/recordsets")],
    ),
    base.APIRule(
        name="get_recordset",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s) or (\"True\":%(zone_shared)s)"),
        description="Get recordset",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}/recordsets/{recordset_id}")],
    ),
    base.APIRule(
        name="find_recordsets",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="List Recordsets in a Zone",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}/recordsets")],
    ),
    base.APIRule(
        name="update_recordset",
        check_str=("(role:member and project_id:%(project_id)s) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('SECONDARY':%(zone_type)s) or role:member and (project_id:%(recordset_project_id)s) and ('PRIMARY':%(zone_type)s)"),
        description="Update recordset",
        scope_types=["project"],
        operations=[Operation(method="PUT", path="/v2/zones/{zone_id}/recordsets/{recordset_id}")],
    ),
    base.APIRule(
        name="delete_recordset",
        check_str=("(role:member and project_id:%(project_id)s) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('PRIMARY':%(zone_type)s) or (role:admin) and ('SECONDARY':%(zone_type)s) or role:member and (project_id:%(recordset_project_id)s) and ('PRIMARY':%(zone_type)s)"),
        description="Delete RecordSet",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/{zone_id}/recordsets/{recordset_id}")],
    ),
    base.APIRule(
        name="find_service_status",
        check_str=("role:admin"),
        description="Find a single Service Status",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/service_status/{service_id}")],
    ),
    base.APIRule(
        name="find_service_statuses",
        check_str=("role:admin"),
        description="List service statuses.",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/service_status")],
    ),
    base.APIRule(
        name="get_zone_share",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Get a Zone Share",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}/shares/{zone_share_id}")],
    ),
    base.APIRule(
        name="share_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Share a Zone",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/shares")],
    ),
    base.APIRule(
        name="find_zone_shares",
        check_str=("@"),
        description="List Shared Zones",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}/shares")],
    ),
    base.APIRule(
        name="unshare_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Unshare Zone",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/{zone_id}/shares/{shared_zone_id}")],
    ),
    base.APIRule(
        name="create_tld",
        check_str=("role:admin"),
        description="Create Tld",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/tlds")],
    ),
    base.APIRule(
        name="find_tlds",
        check_str=("role:admin"),
        description="List Tlds",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/tlds")],
    ),
    base.APIRule(
        name="get_tld",
        check_str=("role:admin"),
        description="Show Tld",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/tlds/{tld_id}")],
    ),
    base.APIRule(
        name="update_tld",
        check_str=("role:admin"),
        description="Update Tld",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/tlds/{tld_id}")],
    ),
    base.APIRule(
        name="delete_tld",
        check_str=("role:admin"),
        description="Delete Tld",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/tlds/{tld_id}")],
    ),
    base.APIRule(
        name="create_tsigkey",
        check_str=("role:admin"),
        description="Create Tsigkey",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/tsigkeys")],
    ),
    base.APIRule(
        name="find_tsigkeys",
        check_str=("role:admin"),
        description="List Tsigkeys",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/tsigkeys")],
    ),
    base.APIRule(
        name="get_tsigkey",
        check_str=("role:admin"),
        description="Show a Tsigkey",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/tsigkeys/{tsigkey_id}")],
    ),
    base.APIRule(
        name="update_tsigkey",
        check_str=("role:admin"),
        description="Update Tsigkey",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/tsigkeys/{tsigkey_id}")],
    ),
    base.APIRule(
        name="delete_tsigkey",
        check_str=("role:admin"),
        description="Delete a Tsigkey",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/tsigkeys/{tsigkey_id}")],
    ),
    base.APIRule(
        name="create_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Create Zone",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones")],
    ),
    base.APIRule(
        name="get_zone",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s) or (\"True\":%(zone_shared)s)"),
        description="Get Zone",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}")],
    ),
    base.APIRule(
        name="get_zone_ns_records",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Get the Name Servers for a Zone",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/{zone_id}/nameservers")],
    ),
    base.APIRule(
        name="find_zones",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="List existing zones",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones")],
    ),
    base.APIRule(
        name="update_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Update Zone",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/zones/{zone_id}")],
    ),
    base.APIRule(
        name="delete_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Delete Zone",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/{zone_id}")],
    ),
    base.APIRule(
        name="xfr_zone",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Manually Trigger an Update of a Secondary Zone",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/tasks/xfr")],
    ),
    base.APIRule(
        name="abandon_zone",
        check_str=("role:admin"),
        description="Abandon Zone",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/tasks/abandon")],
    ),
    base.APIRule(
        name="zone_export",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Retrive a Zone Export from the Designate Datastore",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/exports/{zone_export_id}/export")],
    ),
    base.APIRule(
        name="create_zone_export",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Create Zone Export",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/tasks/export")],
    ),
    base.APIRule(
        name="find_zone_exports",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="List Zone Exports",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/exports")],
    ),
    base.APIRule(
        name="get_zone_export",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Get Zone Exports",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/exports/{zone_export_id}")],
    ),
    base.APIRule(
        name="update_zone_export",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Update Zone Exports",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/tasks/export")],
    ),
    base.APIRule(
        name="delete_zone_export",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Delete a zone export",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/tasks/exports/{zone_export_id}")],
    ),
    base.APIRule(
        name="create_zone_import",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Create Zone Import",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/tasks/imports")],
    ),
    base.APIRule(
        name="find_zone_imports",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="List all Zone Imports",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/imports")],
    ),
    base.APIRule(
        name="get_zone_import",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Get Zone Imports",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/imports/{zone_import_id}")],
    ),
    base.APIRule(
        name="update_zone_import",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Update Zone Imports",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/tasks/imports")],
    ),
    base.APIRule(
        name="delete_zone_import",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Delete a Zone Import",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/tasks/imports/{zone_import_id}")],
    ),
    base.APIRule(
        name="create_zone_transfer_accept",
        check_str=("((role:admin) or (role:member and project_id:%(project_id)s)) or project_id:%(target_project_id)s or None:%(target_project_id)s"),
        description="Create Zone Transfer Accept",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/tasks/transfer_accepts")],
    ),
    base.APIRule(
        name="get_zone_transfer_accept",
        check_str=("(role:admin) or (role:reader and project_id:%(project_id)s)"),
        description="Get Zone Transfer Accept",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/transfer_requests/{zone_transfer_accept_id}")],
    ),
    base.APIRule(
        name="find_zone_transfer_accepts",
        check_str=("role:admin"),
        description="List Zone Transfer Accepts",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/transfer_accepts")],
    ),
    base.APIRule(
        name="create_zone_transfer_request",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Create Zone Transfer Accept",
        scope_types=["project"],
        operations=[Operation(method="POST", path="/v2/zones/{zone_id}/tasks/transfer_requests")],
    ),
    base.APIRule(
        name="get_zone_transfer_request",
        check_str=("((role:admin) or (role:member and project_id:%(project_id)s)) or project_id:%(target_project_id)s or None:%(target_project_id)s"),
        description="Show a Zone Transfer Request",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/transfer_requests/{zone_transfer_request_id}")],
    ),
    base.APIRule(
        name="find_zone_transfer_requests",
        check_str=("@"),
        description="List Zone Transfer Requests",
        scope_types=["project"],
        operations=[Operation(method="GET", path="/v2/zones/tasks/transfer_requests")],
    ),
    base.APIRule(
        name="update_zone_transfer_request",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Update a Zone Transfer Request",
        scope_types=["project"],
        operations=[Operation(method="PATCH", path="/v2/zones/tasks/transfer_requests/{zone_transfer_request_id}")],
    ),
    base.APIRule(
        name="delete_zone_transfer_request",
        check_str=("(role:admin) or (role:member and project_id:%(project_id)s)"),
        description="Delete a Zone Transfer Request",
        scope_types=["project"],
        operations=[Operation(method="DELETE", path="/v2/zones/tasks/transfer_requests/{zone_transfer_request_id}")],
    ),
)

__all__ = ("list_rules",)
