// Copyright 2021 99cloud
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import { isObject } from 'lodash';
import yaml from 'js-yaml';

export const getValue = (value) => {
  if (isObject(value)) {
    try {
      return yaml.safeDump(value, { noRefs: true });
    } catch (err) {
      return JSON.stringify(value, null, 2);
    }
  }
  return String(value);
};
