// Copyright 2021 99cloud
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import { action } from 'mobx';
import client from 'client';
import Base from 'stores/base';

export class TagStore extends Base {
  get client() {
    return client.keystone.projects.tags;
  }

  get projectClient() {
    return client.keystone.projects;
  }

  listFetchByClient(params, originParams) {
    const { project_id } = originParams;
    return this.client.list(project_id, params);
  }

  get paramsFunc() {
    return () => null;
  }

  @action
  update({ project_id }, newObject) {
    return this.submitting(
      this.projectClient.updateTags(project_id, newObject)
    );
  }
}

const globalTagStore = new TagStore();
export default globalTagStore;
