#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright (C) 2013 eNovance SAS <licensing@enovance.com>
#
# Author: Chmouel Boudjnah <chmouel@enovance.com>
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

import setuptools

from swsync.openstack.common import setup

name = 'swsync'

requires = setup.parse_requirements()
depend_links = setup.parse_dependency_links()
entry_point = '%s.middlewares:last_modified' % (name)

setuptools.setup(
    name=name,
    version=setup.get_version(name),
    description='A massive swift syncer',
    url='https://github.com/enovance/swsync',
    license='Apache License (2.0)',
    author='eNovance SAS.',
    author_email='dev@enovance.com',
    packages=setuptools.find_packages(exclude=['tests', 'tests.*']),
    cmdclass=setup.get_cmdclass(),
    install_requires=requires,
    dependency_links=depend_links,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Environment :: OpenStack',
        'Intended Audience :: Developers',
        'Intended Audience :: Information Technology',
        'License :: OSI Approved :: Apache Software License',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2.6',
        'Environment :: No Input/Output (Daemon)',
    ],
    scripts=[
        'bin/swfiller',
        'bin/swsync',
    ],
    entry_points={
        'paste.filter_factory': ['last_modified=%s' % entry_point]
    }
)
