# Copyright 2015 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

""" Alter devices

Revision ID: 12a57080b278
Revises: 12a57080b277
Create Date: 2015-11-26 15:18:19.623170

"""

# revision identifiers, used by Alembic.
revision = '12a57080b278'
down_revision = '12a57080b277'

from alembic import op
from sqlalchemy.dialects import mysql


def upgrade(active_plugins=None, options=None):
    ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(u'deviceattributes', 'device_id',
                    existing_type=mysql.VARCHAR(length=255),
                    nullable=False)
    op.alter_column(u'devices', 'status',
                    existing_type=mysql.VARCHAR(length=255),
                    nullable=False)
    ### end Alembic commands ###


def downgrade(active_plugins=None, options=None):
    ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(u'devices', 'status',
                    existing_type=mysql.VARCHAR(length=255),
                    nullable=True)
    op.alter_column(u'deviceattributes', 'device_id',
                    existing_type=mysql.VARCHAR(length=255),
                    nullable=True)
    ### end Alembic commands ###
