# Copyright 2015 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

"""remove service related

Revision ID: 2774a42c7163
Revises: 12a57080b278
Create Date: 2015-11-26 15:47:51.161749

"""

# revision identifiers, used by Alembic.
revision = '2774a42c7163'
down_revision = '12a57080b278'

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql


def upgrade(active_plugins=None, options=None):
    # commands auto generated by Alembic - please adjust! #
    op.drop_table('servicecontexts')
    op.drop_table('deviceservicecontexts')
    op.drop_table('servicedevicebindings')
    op.drop_table('serviceinstances')
    # end Alembic commands #


def downgrade(active_plugins=None, options=None):
    # commands auto generated by Alembic - please adjust! #
    op.create_table(
        'deviceservicecontexts',
        sa.Column('id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('device_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('network_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('subnet_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('port_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('router_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('role', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('index', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(['device_id'], [u'devices.id'],
                                name=u'deviceservicecontexts_ibfk_1'),
        sa.PrimaryKeyConstraint('id'),
        mysql_default_charset=u'utf8',
        mysql_engine=u'InnoDB'
    )

    op.create_table(
        'serviceinstances',
        sa.Column('tenant_id', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('name', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('service_type_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('service_table_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('managed_by_user', mysql.TINYINT(display_width=1),
                  autoincrement=False, nullable=True),
        sa.Column('mgmt_driver', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('mgmt_url', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('status', mysql.VARCHAR(length=255), nullable=False),
        sa.ForeignKeyConstraint(['service_type_id'], [u'servicetypes.id'],
                                name=u'serviceinstances_ibfk_1'),
        sa.PrimaryKeyConstraint('id'),
        mysql_default_charset=u'utf8',
        mysql_engine=u'InnoDB'
    )

    op.create_table(
        'servicedevicebindings',
        sa.Column('service_instance_id', mysql.VARCHAR(length=36),
                  nullable=False),
        sa.Column('device_id', mysql.VARCHAR(length=36), nullable=False),
        sa.ForeignKeyConstraint(['device_id'], [u'devices.id'],
                                name=u'servicedevicebindings_ibfk_1'),
        sa.ForeignKeyConstraint(['service_instance_id'],
                                [u'serviceinstances.id'],
                                name=u'servicedevicebindings_ibfk_2'),
        sa.PrimaryKeyConstraint('service_instance_id', 'device_id'),
        mysql_default_charset=u'utf8',
        mysql_engine=u'InnoDB'
    )

    op.create_table(
        'servicecontexts',
        sa.Column('id', mysql.VARCHAR(length=36), nullable=False),
        sa.Column('service_instance_id', mysql.VARCHAR(length=36),
                  nullable=True),
        sa.Column('network_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('subnet_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('port_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('router_id', mysql.VARCHAR(length=36), nullable=True),
        sa.Column('role', mysql.VARCHAR(length=255), nullable=True),
        sa.Column('index', mysql.INTEGER(display_width=11),
                  autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(['service_instance_id'],
                                [u'serviceinstances.id'],
                                name=u'servicecontexts_ibfk_1'),
        sa.PrimaryKeyConstraint('id'),
        mysql_default_charset=u'utf8',
        mysql_engine=u'InnoDB'
    )
    # end Alembic commands #
