# Copyright 2021 OpenStack Foundation
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
#

"""introduce_sol_refactored_models

Revision ID: a23ebee909a8
Revises: 6dc60a5760e5
Create Date: 2021-04-20 15:33:42.686284

"""

# flake8: noqa: E402

# revision identifiers, used by Alembic.
revision = 'a23ebee909a8'
down_revision = '6dc60a5760e5'

from alembic import op
import sqlalchemy as sa


def upgrade(active_plugins=None, options=None):
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('LccnSubscriptionV2',
        sa.Column('id', sa.String(length=255), nullable=False),
        sa.Column('filter', sa.JSON(), nullable=True),
        sa.Column('callbackUri', sa.String(length=255), nullable=False),
        sa.Column('authentication', sa.JSON(), nullable=True),
        sa.Column('verbosity',
                  sa.Enum('FULL', 'SHORT', name='verbosity'), nullable=False),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )

    op.create_table('VnfInstanceV2',
        sa.Column('id', sa.String(length=255), nullable=False),
        sa.Column('vnfInstanceName', sa.String(length=255), nullable=True),
        sa.Column('vnfInstanceDescription', sa.Text(), nullable=True),
        sa.Column('vnfdId', sa.String(length=255), nullable=False),
        sa.Column('vnfProvider', sa.String(length=255), nullable=False),
        sa.Column('vnfProductName', sa.String(length=255), nullable=False),
        sa.Column('vnfSoftwareVersion', sa.String(length=255), nullable=False),
        sa.Column('vnfdVersion', sa.String(length=255), nullable=False),
        sa.Column('vnfConfigurableProperties', sa.JSON(), nullable=True),
        sa.Column('vimConnectionInfo', sa.JSON(), nullable=True),
        sa.Column('instantiationState',
                  sa.Enum('NOT_INSTANTIATED', 'INSTANTIATED',
                          name='instantiationState'),
                  nullable=False),
        sa.Column('instantiatedVnfInfo', sa.JSON(), nullable=True),
        sa.Column('metadata', sa.JSON(), nullable=True),
        sa.Column('extensions', sa.JSON(), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )

    op.create_table('VnfLcmOpOccV2',
        sa.Column('id', sa.String(length=255), nullable=False),
        sa.Column('operationState',
                  sa.Enum('STARTING', 'PROCESSING', 'COMPLETED', 'FAILED_TEMP',
                          'FAILED', 'ROLLING_BACK', 'ROLLED_BACK',
                          name='operationState'),
                  nullable=False),
        sa.Column('stateEnteredTime', sa.DateTime(), nullable=False),
        sa.Column('startTime', sa.DateTime(), nullable=False),
        sa.Column('vnfInstanceId', sa.String(length=255), nullable=False),
        sa.Column('grantId', sa.String(length=255), nullable=True),
        sa.Column('operation',
                  sa.Enum('INSTANTIATE', 'SCALE', 'SCALE_TO_LEVEL',
                          'CHANGE_FLAVOUR', 'TERMINATE', 'HEAL', 'OPERATE',
                          'CHANGE_EXT_CONN', 'MODIFY_INFO', 'CREATE_SNAPSHOT',
                          'REVERT_TO_SNAPSHOT', 'CHANGE_VNFPKG',
                          name='operation'),
                  nullable=False),
        sa.Column('isAutomaticInvocation', sa.Boolean(), nullable=False),
        sa.Column('operationParams', sa.JSON(), nullable=True),
        sa.Column('isCancelPending', sa.Boolean(), nullable=False),
        sa.Column('cancelMode',
                  sa.Enum('GRACEFUL', 'FORCEFUL', name='cancelMode'),
                  nullable=True),
        sa.Column('error', sa.JSON(), nullable=True),
        sa.Column('resourceChanges', sa.JSON(), nullable=True),
        sa.Column('changedInfo', sa.JSON(), nullable=True),
        sa.Column('changedExtConnectivity', sa.JSON(), nullable=True),
        sa.Column('modificationsTriggeredByVnfPkgChange', sa.JSON(),
                  nullable=True),
        sa.Column('vnfSnapshotInfoId', sa.String(length=255), nullable=True),
        sa.PrimaryKeyConstraint('id'),
        mysql_engine='InnoDB'
    )
    # ### end Alembic commands ###
