# Copyright 2014 NEC Corporation.  All rights reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import copy

from tempest.api_schema.response.compute import availability_zone as common


base = {
    'status_code': [200],
    'response_body': {
        'type': 'object',
        'properties': {
            'availability_zone_info': {
                'type': 'array',
                'items': {
                    'type': 'object',
                    'properties': {
                        'zone_name': {'type': 'string'},
                        'zone_state': {
                            'type': 'object',
                            'properties': {
                                'available': {'type': 'boolean'}
                            },
                            'required': ['available']
                        },
                        # NOTE: Here is the difference between detail and
                        # non-detail
                        'hosts': {'type': 'null'}
                    },
                    'required': ['zone_name', 'zone_state', 'hosts']
                }
            }
        },
        'required': ['availability_zone_info']
    }
}

get_availability_zone_list = copy.deepcopy(base)
get_availability_zone_list_detail = copy.deepcopy(base)
get_availability_zone_list_detail['response_body']['properties'][
    'availability_zone_info']['items']['properties']['hosts'] = common.detail
