# The functions in this library are used to get scancode strings for VirtualBox
# keyboard input (keyboardputscancode).
#
# It was generated mostly from output of Cameron Kerr's scancodes.l:
# http://humbledown.org/keyboard-scancodes.xhtml
#
# The library works with bash 3.2 (shipped with Mac OS X as of 2014).

function char2scancode {
    local key=$1
    case "$key" in
        'a')
            echo -n " 1e 9e"
            ;;
        'b')
            echo -n " 30 b0"
            ;;
        'c')
            echo -n " 2e ae"
            ;;
        'd')
            echo -n " 20 a0"
            ;;
        'e')
            echo -n " 12 92"
            ;;
        'f')
            echo -n " 21 a1"
            ;;
        'g')
            echo -n " 22 a2"
            ;;
        'h')
            echo -n " 23 a3"
            ;;
        'i')
            echo -n " 17 97"
            ;;
        'j')
            echo -n " 24 a4"
            ;;
        'k')
            echo -n " 25 a5"
            ;;
        'l')
            echo -n " 26 a6"
            ;;
        'm')
            echo -n " 32 b2"
            ;;
        'n')
            echo -n " 31 b1"
            ;;
        'o')
            echo -n " 18 98"
            ;;
        'p')
            echo -n " 19 99"
            ;;
        'q')
            echo -n " 10 90"
            ;;
        'r')
            echo -n " 13 93"
            ;;
        's')
            echo -n " 1f 9f"
            ;;
        't')
            echo -n " 14 94"
            ;;
        'u')
            echo -n " 16 96"
            ;;
        'v')
            echo -n " 2f af"
            ;;
        'w')
            echo -n " 11 91"
            ;;
        'x')
            echo -n " 2d ad"
            ;;
        'y')
            echo -n " 15 95"
            ;;
        'z')
            echo -n " 2c ac"
            ;;
        'A')
            echo -n " 2a 1e 9e aa"
            ;;
        'B')
            echo -n " 2a 30 b0 aa"
            ;;
        'C')
            echo -n " 2a 2e ae aa"
            ;;
        'D')
            echo -n " 2a 20 a0 aa"
            ;;
        'E')
            echo -n " 2a 12 92 aa"
            ;;
        'F')
            echo -n " 2a 21 a1 aa"
            ;;
        'G')
            echo -n " 2a 22 a2 aa"
            ;;
        'H')
            echo -n " 2a 23 a3 aa"
            ;;
        'I')
            echo -n " 2a 17 97 aa"
            ;;
        'J')
            echo -n " 2a 24 a4 aa"
            ;;
        'K')
            echo -n " 2a 25 a5 aa"
            ;;
        'L')
            echo -n " 2a 26 a6 aa"
            ;;
        'M')
            echo -n " 2a 32 b2 aa"
            ;;
        'N')
            echo -n " 2a 31 b1 aa"
            ;;
        'O')
            echo -n " 2a 18 98 aa"
            ;;
        'P')
            echo -n " 2a 19 99 aa"
            ;;
        'Q')
            echo -n " 2a 10 90 aa"
            ;;
        'R')
            echo -n " 2a 13 93 aa"
            ;;
        'S')
            echo -n " 2a 1f 9f aa"
            ;;
        'T')
            echo -n " 2a 14 94 aa"
            ;;
        'U')
            echo -n " 2a 16 96 aa"
            ;;
        'V')
            echo -n " 2a 2f af aa"
            ;;
        'W')
            echo -n " 2a 11 91 aa"
            ;;
        'X')
            echo -n " 2a 2d ad aa"
            ;;
        'Z')
            echo -n " 2a 2c ac aa"
            ;;
        'Y')
            echo -n " 2a 15 95 aa"
            ;;
        '1')
            echo -n " 02 82"
            ;;
        '2')
            echo -n " 03 83"
            ;;
        '3')
            echo -n " 04 84"
            ;;
        '4')
            echo -n " 05 85"
            ;;
        '5')
            echo -n " 06 86"
            ;;
        '6')
            echo -n " 07 87"
            ;;
        '7')
            echo -n " 08 88"
            ;;
        '8')
            echo -n " 09 89"
            ;;
        '9')
            echo -n " 0a 8a"
            ;;
        '0')
            echo -n " 0b 8b"
            ;;
        '!')
            echo -n " 2a 02 82 aa"
            ;;
        '@')
            echo -n " 2a 03 83 aa"
            ;;
        '#')
            echo -n " 2a 04 84 aa"
            ;;
        '$')
            echo -n " 2a 05 85 aa"
            ;;
        '%')
            echo -n " 2a 06 86 aa"
            ;;
        '^')
            echo -n " 2a 07 87 aa"
            ;;
        '&')
            echo -n " 2a 08 88 aa"
            ;;
        '*')
            echo -n " 2a 09 89 aa"
            ;;
        '(')
            echo -n " 2a 0a 8a aa"
            ;;
        ')')
            echo -n " 2a 0b 8b aa"
            ;;
        '-')
            echo -n " 0c 8c"
            ;;
        '_')
            echo -n " 2a 0c 8c aa"
            ;;
        '=')
            echo -n " 0d 8d"
            ;;
        '+')
            echo -n " 2a 0d 8d aa"
            ;;
        ' ')
            echo -n " 39 b9"
            ;;
        '[')
            echo -n " 1a 9a"
            ;;
        ']')
            echo -n " 1b 9b"
            ;;
        '{')
            echo -n " 2a 1a 9a aa"
            ;;
        '}')
            echo -n " 2a 1b 9b aa"
            ;;
        ';')
            echo -n " 27 a7"
            ;;
        ':')
            echo -n " 2a 27 a7 aa"
            ;;
        ',')
            echo -n " 33 b3"
            ;;
        '.')
            echo -n " 34 b4"
            ;;
        '/')
            echo -n " 35 b5"
            ;;
        '\')
            echo -n " 2b ab"
            ;;
        '|')
            echo -n " 2a 2b ab aa"
            ;;
        '?')
            echo -n " 2a 35 b5 aa"
            ;;
        '"')
            echo -n " 2a 28 a8 aa"
            ;;
        "'")
            echo -n " 28 a8"
            ;;
        ">")
            echo -n " 2a 34 b4 aa"
            ;;
        "<")
            echo -n " 2a 33 b3 aa"
            ;;
    esac
}

function esc2scancode {
    echo -n " 01 81"
}

function enter2scancode {
    echo -n " 1c 9c"
}

# vim: set ai ts=4 sw=4 et ft=sh:
