# Copyright 2017 SZZT  Co., Ltd.
# All Rights Reserved
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import sqlalchemy as sql


def upgrade(migrate_engine):
    meta = sql.MetaData()
    meta.bind = migrate_engine

    recycle_resources = sql.Table(
        'deleting_resources', meta,
        sql.Column('resource_id', sql.String(length=127), nullable=False),
        sql.Column('resource_type', sql.String(length=64), nullable=False),
        sql.Column('deleted_at', sql.DateTime),
        mysql_engine='InnoDB',
        mysql_charset='utf8')

    recycle_resources.create()


def downgrade(migrate_engine):
    raise NotImplementedError('downgrade not support')
