#!/usr/bin/env bash

# Copyright 2017 Red Hat Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"); you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

# Ensure that all of our source files contain the Apache 2.0 license header

files=$(git grep --files-without-match -e 'Red Hat' '*.js' '*.less')

if [ -z "$files" ]
then
    exit 0
else
    echo "The following files are missing a license header:"
    echo ""
    echo "$files"
    exit 1
fi
