/**
 * Copyright 2018 Red Hat Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may obtain
 * a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

import PropTypes from 'prop-types';
import React from 'react';
import { Redirect } from 'react-router-dom';

import DeploymentConfirmation from '../deployment/DeploymentConfirmation';
import { deploymentStates as ds } from '../../constants/DeploymentConstants';

const DeploymentConfirmationRoute = ({ currentPlanName, deploymentStatus }) =>
  [ds.UNDEPLOYED, ds.UNKNOWN, ds.STARTING_DEPLOYMENT].includes(
    deploymentStatus
  ) ? (
    <DeploymentConfirmation />
  ) : (
    <Redirect to={`/plans/${currentPlanName}`} />
  );
DeploymentConfirmationRoute.propTypes = {
  currentPlanName: PropTypes.string.isRequired,
  deploymentStatus: PropTypes.string.isRequired
};

export default DeploymentConfirmationRoute;
