# Copyright 2014 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from trove_tempest_plugin.services.database import base_client


class FlavorsClient(base_client.BaseClient):

    uri = '/flavors'

    def list_flavors(self):
        return self.list_resources(self.uri)

    def show_flavor(self, flavor_id):
        uri = '%s/%s' % (self.uri, flavor_id)
        return self.show_resource(uri)
