# -*- encoding: utf-8 -*-
#
# Copyright 2013 Hewlett-Packard Development Company, L.P.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""Starter script for the Applier service."""

import os
import sys

from oslo_log import log

from watcher.applier import manager
from watcher.applier import sync
from watcher.common import service as watcher_service
from watcher import conf

LOG = log.getLogger(__name__)
CONF = conf.CONF


def main():
    watcher_service.prepare_service(sys.argv, CONF)

    LOG.info('Starting Watcher Applier service in PID %s', os.getpid())

    applier_service = watcher_service.Service(manager.ApplierManager)

    syncer = sync.Syncer()
    syncer.sync()

    # Only 1 process
    launcher = watcher_service.launch(CONF, applier_service)
    launcher.wait()
