# Copyright (c) 2017 OpenStack Foundation
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

from zun.api import servicegroup
from zun.scheduler import filters


class NoopFilter(filters.BaseHostFilter):
    """Noop filter for now"""

    def __init__(self):
        self.servicegroup_api = servicegroup.ServiceGroup()

    # Host state does not change within a request
    run_filter_once_per_request = True

    def host_passes(self, host_state, container):
        """Noop filter for now"""

        # Depend on the objects.NodeInfo of below patch to filter node,
        # https://review.openstack.org/#/c/436572/6, no more thing can do now.
        return True
