<?php
/**
 * @file
 * Custom tokens for Metatag.
 */

/**
 * Implements hook_token_info().
 */
function metatag_token_info() {
  $info = array();

  $info['types']['metatag'] = array(
    'name' => t('Meta tags'),
    'description' => t('Generated by the Metatag module, may not be used to fill in other meta tags.'),
  );

  $metatag_info = metatag_get_info();

  foreach($metatag_info['tags'] as $value) {
    $info['tokens']['metatag'][$value['name']] = array(
      'name' => $value['label'],
      'description' => $value['description']
    );
  }

  if (module_exists('taxonomy')) {
    $info['tokens']['term']['metatag'] = array(
      'name' => t('Metatag.'),
      'description' => t('Metatag.'),
      'type' => 'metatag'
    );
  }

  if (module_exists('node')) {
    $info['tokens']['node']['metatag'] = array(
      'name' => t('Metatag.'),
      'description' => t('Metatag.'),
      'type' => 'metatag'
    );
  }

  return $info;
}

/**
 * Implements hook_tokens().
 */
function metatag_tokens($type, $tokens, array $data = array(), array $options = array()) {
  $replacements = array();

  $sanitize = !empty($options['sanitize']);

  // Metatag tokens.
  if ($type == 'metatag' && !empty($data['metatag'])) {
    $metatag = $data['metatag'];
    foreach ($tokens as $name => $original) {
      if(isset($metatag[$name])){
        $replacements[$original] = $sanitize ? filter_xss($metatag[$name]) : $metatag[$name];
      }
    }
  }

  // Token tokens.
  if ($type == 'term' && !empty($data['term'])) {
    $term = $data['term'];

    if ($metatag_tokens = token_find_with_prefix($tokens, 'metatag')) {
      $result = metatag_token_generate_array($term, 'taxonomy_term', $term->vocabulary_machine_name);
      $replacements += token_generate('metatag', $metatag_tokens, array('metatag' => $result), $options);
    }
  }

  // Node tokens.
  if ($type == 'node' && !empty($data['node'])) {
    $node = $data['node'];

    if ($metatag_tokens = token_find_with_prefix($tokens, 'metatag')) {
      $result = metatag_token_generate_array($node, 'node', $node->type);
      $replacements += token_generate('metatag', $metatag_tokens, array('metatag' => $result), $options);
    }
  }

  return $replacements;
}

/**
 * Generate an array of meta tags for a given entity.
 */
function metatag_token_generate_array($entity, $entity_type, $bundle) {
  if (metatag_entity_supports_metatags($entity_type, $bundle)) {
    $token_type = token_get_entity_mapping('entity', $entity_type);

    $instance = "{$entity_type}:{$bundle}";
    $options = array();
    $options['token data'][$token_type] = $entity;
    $options['entity'] = $entity;

    $metatags = array();
    if (!empty($entity->metatags)) {
      $language = metatag_entity_get_language($entity_type, $entity);
      if (!empty($entity->metatags[$language])) {
        $metatags = $entity->metatags[$language];
      }
    }
    $metatags += metatag_config_load_with_defaults($instance);

    $result = array();
    foreach ($metatags as $metatag => $data) {
      if ($metatag_instance = metatag_get_instance($metatag, $data)) {
        $result[$metatag] = $metatag_instance->getValue($options);
      }
    }
    return $result;
  }

  return NULL;
}
