CREATE OR REPLACE PROCEDURE SP_UPDATE_CONSUMER
(
P_OSR_USA_ID_REF                              IN      NUMBER, 
P_OSR_CONSUMER_KEY                            IN      VARCHAR2, 
P_OSR_CONSUMER_SECRET                         IN      VARCHAR2,
P_OSR_REQUESTER_NAME                          IN      VARCHAR2,
P_OSR_REQUESTER_EMAIL                         IN      VARCHAR2, 
P_OSR_CALLBACK_URI                            IN      VARCHAR2, 
P_OSR_APPLICATION_URI                         IN      VARCHAR2, 
P_OSR_APPLICATION_TITLE                       IN      VARCHAR2, 
P_OSR_APPLICATION_DESCR                       IN      VARCHAR2,
P_OSR_APPLICATION_NOTES                       IN      VARCHAR2, 
P_OSR_APPLICATION_TYPE                        IN      VARCHAR2, 
P_OSR_APPLICATION_COMMERCIAL                  IN      INTEGER,
P_RESULT                                      OUT     NUMBER
)
AS

 -- PROCEDURE TO Insert a new consumer with this server (we will be the server)
BEGIN
P_RESULT := 0;


 INSERT INTO OAUTH_SERVER_REGISTRY
 ( OSR_ID, OSR_ENABLED, OSR_STATUS,OSR_USA_ID_REF,OSR_CONSUMER_KEY, OSR_CONSUMER_SECRET,OSR_REQUESTER_NAME,
					OSR_REQUESTER_EMAIL, OSR_CALLBACK_URI, OSR_APPLICATION_URI, OSR_APPLICATION_TITLE, OSR_APPLICATION_DESCR,
					OSR_APPLICATION_NOTES, OSR_APPLICATION_TYPE, OSR_APPLICATION_COMMERCIAL, OSR_TIMESTAMP, OSR_ISSUE_DATE)
 VALUES
 ( SEQ_OSR_ID.NEXTVAL, 1, 'ACTIVE', P_OSR_USA_ID_REF, P_OSR_CONSUMER_KEY, P_OSR_CONSUMER_SECRET,P_OSR_REQUESTER_NAME,
					P_OSR_REQUESTER_EMAIL, P_OSR_CALLBACK_URI, P_OSR_APPLICATION_URI, P_OSR_APPLICATION_TITLE, P_OSR_APPLICATION_DESCR,
					P_OSR_APPLICATION_NOTES, P_OSR_APPLICATION_TYPE, P_OSR_APPLICATION_COMMERCIAL, SYSDATE, SYSDATE); 
    
              
EXCEPTION
WHEN OTHERS THEN
-- CALL THE FUNCTION TO LOG ERRORS
ROLLBACK;
P_RESULT := 1; -- ERROR
END;
/
