<?php

/*
 * This file is part of the Behat.
 * (c) Konstantin Kudryashov <ever.zet@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Behat\Behat\EventDispatcher\Event;

use Behat\Gherkin\Node\FeatureNode;
use Behat\Testwork\Environment\Environment;
use Behat\Testwork\EventDispatcher\Event\BeforeTested;

/**
 * Represents an event before feature tested.
 *
 * @author Konstantin Kudryashov <ever.zet@gmail.com>
 */
final class BeforeFeatureTested extends FeatureTested implements BeforeTested
{
    /**
     * @var FeatureNode
     */
    private $feature;

    /**
     * Initializes event.
     *
     * @param Environment $env
     * @param FeatureNode $feature
     */
    public function __construct(Environment $env, FeatureNode $feature)
    {
        parent::__construct($env);

        $this->feature = $feature;
    }

    /**
     * Returns feature.
     *
     * @return FeatureNode
     */
    public function getFeature()
    {
        return $this->feature;
    }
}
