---
layout: default
title: Security Policy
permalink: /docs/security/
---

This document describes what to do in case of a security issue with `league/flysystem`.

## Vulnerability Response

Your report will be acknowledged within 2 business days. Any information shared with
the security team stays will not be shared with other parties except as required to
get the issue fixed or to coordinate a vendor response. As a security issue moves
through our process, during which the reporter will be kept up-to-date.

Our goal is to disclose bugs as soon as possible once a user mitigation is available.
We will set a disclosure date once the bug is well-understood (in consultation with
the bug reporter and the relevant project maintainers).

## Security process

Here are the steps:

1. The person discovering an issue (the reporter) privately reports it to
   <a href="mailto:security@flysystem.io">security@flysystem.io</a>.
2. The security team will reply to the reporter within two business days to acknowledge receipt.
3. The security team will investigate the report.
4. If the report is rejected, the process will stop. If accepted, the process continues.
5. The security team will obtain a CVE number for the vulnerability.
6. A fix and an announcement will be prepared.
7. The fix and announcement will be shared with the reporter for verification.
8. A release plan will be made in accordance with the reporter.
9. A release will be published.
10. The vulnerability will be announced. 
