# -*- coding: utf-8 -*-
#
# PHP OpenStack SDK documentation build configuration file, created by
# sphinx-quickstart on Tue Apr 14 15:09:59 2015.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import sys
import os
from sphinx.highlighting import lexers
from pygments.lexers.web import PhpLexer

sys.path.append(os.path.abspath('_exts'))

lexers['php'] = PhpLexer(startinline=True, linenos=1)
lexers['php-annotations'] = PhpLexer(startinline=True, linenos=1)
primary_domain = 'php'

extensions = ['samples', 'refdoc', 'sphinx.ext.autodoc', 'sphinx.ext.autosummary', 'sphinxcontrib.phpdomain']
source_suffix = '.rst'
master_doc = 'index'
project = u'php-opencloud'
copyright = u'2015, Jamie Hannaford'
version = '1.12'
release = '1.12.1'
exclude_patterns = ['_build']
pygments_style = 'sphinx'

html_theme = 'sphinx_rtd_theme'
html_theme_path = ["_templates", ]

# Output file base name for HTML help builder.
htmlhelp_basename = 'php-openclouddoc'

latex_documents = [
  ('index', 'php-opencloud.tex', u'php-opencloud Documentation',
   u'Jamie Hannaford', 'manual'),
]

man_pages = [
    ('index', 'php-opencloud', u'php-opencloud Documentation',
     [u'Jamie Hannaford'], 1)
]

texinfo_documents = [
  ('index', 'php-opencloud', u'php-opencloud Documentation',
   u'Jamie Hannaford', 'php-opencloud', 'One line description of project.',
   'Miscellaneous'),
]
