<?php

use openid\model\ITrustedSite;

class OpenIdTrustedSite extends Eloquent implements ITrustedSite
{

	protected $fillable = array('realm','user_id', 'policy', 'data');

    public $timestamps = false;
    protected $table = 'openid_trusted_sites';

    public function getRealm()
    {
        return $this->realm;
    }

    public function getUITrustedData()
    {
        $data = $this->getData();
        $str = '';
        foreach ($data as $val) {
            $str .= $val . ', ';
        }
        return trim($str, ', ');
    }

    public function getData()
    {
        $res = is_null($this->data)?'[]':$this->data;
        return json_decode($res);
    }

    public function getUser()
    {
        return $this->user();
    }

    public function user()
    {
        return $this->belongsTo('auth\User');
    }

    public function getAuthorizationPolicy()
    {
        return $this->policy;
    }

}