<?php

use utils\services\UtilsServiceCatalog;
use openid\services\OpenIdServiceCatalog;
/*
|--------------------------------------------------------------------------
| Create The Application
|--------------------------------------------------------------------------
|
| The first thing we will do is create a new Laravel application instance
| which serves as the "glue" for all the components of Laravel, and is
| the IoC container for the system binding all of the various parts.
|
*/

$app = new Illuminate\Foundation\Application;


/*
|--------------------------------------------------------------------------
| Detect The Application Environment
|--------------------------------------------------------------------------
|
| Laravel takes a dead simple approach to your application environments
| so you can just specify a machine name or HTTP host that matches a
| given environment, then we will automatically detect it for you.
|
*/
/**
 * REMARK UPGRADE FROM 4.0.* to 4.1.*
 * For security reasons, URL domains may no longer be used to detect your application environment.
 * These values are easily spoofable and allow attackers to modify the environment for a request.
 * You should convert your environment detection to use machine host names (hostname command on Mac & Ubuntu).
 */

require __DIR__.'/environment.php';


/*
|--------------------------------------------------------------------------
| Bind Paths
|--------------------------------------------------------------------------
|
| Here we are binding the paths configured in paths.php to the app. You
| should not be changing these here. If you need to change these you
| may do so within the paths.php file and they will be bound here.
|
*/

$app->bindInstallPaths(require __DIR__.'/paths.php');

/*
|--------------------------------------------------------------------------
| Load The Application
|--------------------------------------------------------------------------
|
| Here we will load the Illuminate application. We'll keep this is in a
| separate location so we can isolate the creation of an application
| from the actual running of the application with a given request.
|
*/

$framework = $app['path.base'].'/vendor/laravel/framework/src';

require $framework.'/Illuminate/Foundation/start.php';


//custom authentication
use Illuminate\Auth\Guard;
use auth\CustomAuthProvider;

Auth::extend('custom', function($app) {
    return new Guard(
        new CustomAuthProvider(
	        App::make('auth\\IUserRepository'),
	        App::make('auth\\IMemberRepository'),
	        App::make('auth\\IAuthenticationExtensionService'),
	        App::make(OpenIdServiceCatalog::UserService),
	        App::make(UtilsServiceCatalog::CheckPointService),
	        App::make(UtilsServiceCatalog::TransactionService),
	        App::make(UtilsServiceCatalog::LogService)
            ),
        App::make('session.store')
    );
});


/*
|--------------------------------------------------------------------------
| Return The Application
|--------------------------------------------------------------------------
|
| This script returns the application instance. The instance is given to
| the calling script so we can separate the building of the instances
| from the actual running of the application and sending responses.
|
*/

return $app;


