#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

import mock

from tuskarclient import client
from tuskarclient.common import auth
from tuskarclient.openstack.common.apiclient import client as apiclient
from tuskarclient.tests import utils as tutils


class ClientGetClientTest(tutils.TestCase):
    def setUp(self):
        super(ClientGetClientTest, self).setUp()
        self.kwargs = {
            'os_username': 'os_username',
            'os_password': 'os_password',
            'os_tenant_name': 'os_tenant_name',
            'os_auth_token': 'os_auth_token',
            'os_auth_url': 'os_auth_url',
            'tuskar_url': 'tuskar_url',
            'os_cacert': 'os_cacert',
            'os_cert': 'os_cert',
            'os_key': 'os_key',
        }
        self.client_kwargs = {
            'username': 'os_username',
            'password': 'os_password',
            'tenant_name': 'os_tenant_name',
            'token': 'os_auth_token',
            'auth_url': 'os_auth_url',
            'endpoint': 'tuskar_url',
            'cacert': 'os_cacert',
            'cert': 'os_cert',
            'key': 'os_key',
        }
        self.api_version = 2

    @mock.patch.object(client, 'Client')
    def test_it_works(self, mocked_Client):
        mocked_Client.return_value = 'client'
        self.assertEqual(client.get_client(self.api_version, **self.kwargs),
                         'client')
        mocked_Client.assert_called_with(self.api_version,
                                         **self.client_kwargs)

    @mock.patch.object(client, 'Client')
    def test_it_raises_error_without_proper_params(
            self,
            mocked_Client):

        mocked_Client.return_value = None
        kwargs = self.kwargs.copy()
        del kwargs['os_password']
        self.assertRaises(ValueError,
                          client.get_client, self.api_version, **self.kwargs
                          )
        mocked_Client.assert_called_with(self.api_version,
                                         **self.client_kwargs)


class ClientClientTest(tutils.TestCase):
    def setUp(self):
        super(ClientClientTest, self).setUp()
        self.client_kwargs = {
            'username': 'os_username',
            'password': 'os_password',
            'tenant_name': 'os_tenant_name',
            'token': 'os_auth_token',
            'auth_url': 'os_auth_url',
            'endpoint': 'tuskar_url'
        }
        self.api_version = 2

    @mock.patch.object(apiclient, 'HTTPClient')
    @mock.patch.object(auth, 'KeystoneAuthPlugin')
    def test_client_initialization(self, mocked_KeystoneAuthPlugin,
                                   mocked_HTTPClient):
        client.Client(self.api_version, **self.client_kwargs)
        mocked_KeystoneAuthPlugin.assert_called_with(**self.client_kwargs)
        mocked_HTTPClient.assert_called_with(mocked_KeystoneAuthPlugin())
