# Copyright 2016 99cloud, Inc.
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.


from oslotest import base as test_base
from valenceclient.common.apiclient import base


class HumanResource(base.Resource):
    HUMAN_ID = True


class TestBase(test_base.BaseTestCase):

    def test_resource_repr(self):
        r = base.Resource(None, dict(foo="bar", baz="spam"))
        self.assertEqual("<Resource baz=spam, foo=bar>", repr(r))

    def test_getid(self):
        self.assertEqual(4, base.getid(4))

        class TmpObject(object):
            id = 4
        self.assertEqual(4, base.getid(TmpObject))

    def test_human_id(self):
        r = base.Resource(None, {"name": "1"})
        self.assertIsNone(r.human_id)
        r = HumanResource(None, {"name": "1"})
        self.assertEqual("1", r.human_id)
        r = HumanResource(None, {"name": None})
        self.assertIsNone(r.human_id)

    def test_two_resources_with_same_id_are_not_equal(self):
        # Two resources with same ID: never equal if their info is not equal
        r1 = base.Resource(None, {'id': 1, 'name': 'hi'})
        r2 = base.Resource(None, {'id': 1, 'name': 'hello'})
        self.assertNotEqual(r1, r2)

    def test_two_resources_with_same_id_and_info_are_equal(self):
        # Two resources with same ID: equal if their info is equal
        r1 = base.Resource(None, {'id': 1, 'name': 'hello'})
        r2 = base.Resource(None, {'id': 1, 'name': 'hello'})
        self.assertEqual(r1, r2)

    def test_two_resources_with_diff_type_are_not_equal(self):
        # Two resoruces of different types: never equal
        r1 = base.Resource(None, {'id': 1})
        r2 = HumanResource(None, {'id': 1})
        self.assertNotEqual(r1, r2)

    def test_two_resources_with_no_id_are_equal(self):
        # Two resources with no ID: equal if their info is equal
        r1 = base.Resource(None, {'name': 'joe', 'age': 12})
        r2 = base.Resource(None, {'name': 'joe', 'age': 12})
        self.assertEqual(r1, r2)
