import mock
import requests

from orm.services.customer_manager.cms_rest.controllers.v1.orm.group\
    import region_roles
from orm.services.customer_manager.cms_rest.logic.error_base import ErrorStatus
from orm.services.customer_manager.cms_rest.model import GroupModels
from orm.tests.unit.cms import FunctionalTest
from wsme.exc import ClientSideError

group_logic_mock = None


class TestGroupsRegionRoleController(FunctionalTest):
    def setUp(self):
        FunctionalTest.setUp(self)

        region_roles.authentication = mock.MagicMock()
        region_roles.GroupLogic = get_mock_group_logic

        region_roles.GroupLogic.return_error = 0
        region_roles.utils = mock.MagicMock()
        region_roles.utils.audit_trail.return_value = None
        region_roles.err_utils = mock.MagicMock()

    def tearDown(self):
        FunctionalTest.tearDown(self)

    def test_assign_roles_to_group_region(self):
        # given
        requests.post = mock.MagicMock(return_value=ResponseMock(200))

        # when
        response = self.app.post_json(
            '/v1/orm/groups/{groups id}/regions/{region id}/roles/',
            GROUPS_ROLE_JSON)

        # assert
        assert response.status_int == 200
        assert region_roles.utils.audit_trail.called
        assert group_logic_mock.assign_roles_called

    def test_assign_roles_to_group_region_fail(self):
        # given
        requests.post = mock.MagicMock()

        region_roles.GroupLogic.return_error = 1

        region_roles.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 500))
        # when
        response = self.app.post_json(
            '/v1/orm/groups/{groups id}/regions/{region id}/roles/',
            GROUPS_ROLE_JSON, expect_errors=True)
        # assert
        self.assertEqual(response.status_int, 500)

    def test_assign_roles_to_group_region_bad_request(self):
        # given
        requests.post = mock.MagicMock()

        region_roles.GroupLogic.return_error = 2
        region_roles.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 404))

        # when
        response = self.app.post_json(
            '/v1/orm/groups/{groups_id}/regions/{region id}/roles/',
            GROUPS_ROLE_JSON, expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 404)


def get_mock_group_logic():
    global group_logic_mock
    group_logic_mock = mock.MagicMock()

    if region_roles.GroupLogic.return_error == 0:
        res = GroupModels.RoleResultWrapper(transaction_id='1',
                                            roles=[],
                                            links={},
                                            created='1')

        group_logic_mock.assign_roles.return_value = res

    elif region_roles.GroupLogic.return_error == 1:
        group_logic_mock.assign_roles.side_effect = SystemError()

    elif region_roles.GroupLogic.return_error == 2:
        group_logic_mock.assign_roles.side_effect = ErrorStatus(
            status_code=404)

    return group_logic_mock


class ResponseMock:
    def __init__(self, status_code=200):
        self.status_code = status_code


GROUPS_ROLE_JSON = [
    {
        "customer": "customer-id",
        "roles": [
            "role1",
            "role2"
        ]
    }
]
