import mock
import requests
from wsme.exc import ClientSideError

from orm.services.customer_manager.cms_rest.controllers.v1.orm.group \
    import region_users
from orm.services.customer_manager.cms_rest.logic.error_base import ErrorStatus
from orm.services.customer_manager.cms_rest.model import GroupModels
from orm.tests.unit.cms import FunctionalTest

group_logic_mock = None


class TestGroupsRgnUserController(FunctionalTest):
    def setUp(self):
        FunctionalTest.setUp(self)

        region_users.authentication = mock.MagicMock()

        region_users.GroupLogic = get_mock_group_logic
        region_users.GroupLogic.return_error = 0

        region_users.utils = mock.MagicMock()
        region_users.utils.audit_trail.return_value = None

        region_users.err_utils = mock.MagicMock()

    def tearDown(self):
        FunctionalTest.tearDown(self)

    def test_add_region_users(self):
        # given
        requests.post = mock.MagicMock(return_value=ResponseMock(200))

        # when
        response = self.app.post_json(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/',
            GROUPS_USER_JSON)

        # assert
        self.assertEqual(response.status_int, 200)
        self.assertTrue(group_logic_mock.add_group_region_users.called)

    def test_add_region_users_fail(self):
        # given
        requests.post = mock.MagicMock()

        region_users.GroupLogic.return_error = 1
        region_users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 500))
        # when
        response = self.app.post_json(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/',
            GROUPS_USER_JSON,
            expect_errors=True)
        # assert
        self.assertEqual(response.status_int, 500)

    def test_add_region_users_fail_bad_request(self):
        # given
        requests.post = mock.MagicMock()

        region_users.GroupLogic.return_error = 2
        region_users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 404))
        # when
        response = self.app.post_json(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/',
            GROUPS_USER_JSON,
            expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 404)

    def test_delete_region_user(self):
        # given
        requests.delete = mock.MagicMock(return_value=ResponseMock(200))

        # when
        response = self.app.delete(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/'
            '{user_id}/{domain}')

        # assert
        self.assertEqual(response.status_int, 204)
        self.assertTrue(group_logic_mock.delete_group_region_user.called)

    def test_delete_region_user_fail(self):
        # given
        requests.delete = mock.MagicMock()

        region_users.GroupLogic.return_error = 1
        region_users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 500))

        # when
        response = self.app.delete(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/'
            '{user_id}/{domain}', expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 500)

    def test_delete_region_user_fail_bad_request(self):
        # given
        requests.delete = mock.MagicMock()

        region_users.GroupLogic.return_error = 2
        region_users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 404))

        # when
        response = self.app.delete(
            '/v1/orm/groups/{group id}/regions/{region_id}/users/'
            '{user_id}/{domain}', expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 404)


def get_mock_group_logic():
    global group_logic_mock
    group_logic_mock = mock.MagicMock()

    if region_users.GroupLogic.return_error == 0:
        res = GroupModels.RegionUserResultWrapper(transaction_id='1',
                                                  users=[],
                                                  links={},
                                                  created='1')

        group_logic_mock.add_group_region_users.return_value = res

    elif region_users.GroupLogic.return_error == 1:
        group_logic_mock.add_group_region_users.side_effect = SystemError()
        group_logic_mock.delete_group_region_user.side_effect = SystemError()

    else:
        group_logic_mock.add_group_region_users.side_effect = ErrorStatus(
            status_code=404)
        group_logic_mock.delete_group_region_user.side_effect = ErrorStatus(
            status_code=404)

    return group_logic_mock


class ResponseMock:
    def __init__(self, status_code=200):
        self.status_code = status_code


GROUPS_USER_JSON = [
    {
        "id": ["attuser1"],
        "domain": "nc"
    }
]
