import mock
import requests
from wsme.exc import ClientSideError

from orm.services.customer_manager.cms_rest.controllers.v1.orm.group \
    import users
from orm.services.customer_manager.cms_rest.logic.error_base import ErrorStatus
from orm.services.customer_manager.cms_rest.model import GroupModels
from orm.tests.unit.cms import FunctionalTest

group_logic_mock = None


class TestGroupsUserController(FunctionalTest):
    def setUp(self):
        FunctionalTest.setUp(self)

        users.authentication = mock.MagicMock()

        users.GroupLogic = get_mock_group_logic
        users.GroupLogic.return_error = 0

        users.utils = mock.MagicMock()
        users.utils.audit_trail.return_value = None

        users.err_utils = mock.MagicMock()

    def tearDown(self):
        FunctionalTest.tearDown(self)

    def test_add_default_users(self):
        # given
        requests.post = mock.MagicMock(return_value=ResponseMock(200))

        # when
        response = self.app.post_json('/v1/orm/groups/{group id}/users/',
                                      GROUPS_USER_JSON)

        # assert
        self.assertEqual(response.status_int, 200)
        self.assertTrue(group_logic_mock.add_group_default_users.called)

    def test_add_default_users_fail(self):
        # given
        requests.post = mock.MagicMock()

        users.GroupLogic.return_error = 1
        users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 500))
        # when
        response = self.app.post_json('/v1/orm/groups/{group id}/users/',
                                      GROUPS_USER_JSON,
                                      expect_errors=True)
        # assert
        self.assertEqual(response.status_int, 500)

    def test_add_default_users_fail_bad_request(self):
        # given
        requests.post = mock.MagicMock()

        users.GroupLogic.return_error = 2
        users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 404))
        # when
        response = self.app.post_json('/v1/orm/groups/{group id}/users/',
                                      GROUPS_USER_JSON,
                                      expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 404)

    def test_delete_default_user(self):
        # given
        requests.delete = mock.MagicMock(return_value=ResponseMock(200))

        # when
        response = self.app.delete('/v1/orm/groups/{group id}/users/{user_id}/{domain}')

        # assert
        self.assertEqual(response.status_int, 204)
        # uncomment below line when delete_default_user is implemented
        # self.assertTrue(users.utils.audit_trail.called)
        self.assertTrue(group_logic_mock.delete_group_default_user.called)

    def test_delete_default_user_fail(self):
        # given
        requests.delete = mock.MagicMock()

        users.GroupLogic.return_error = 1
        users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 500))

        # when
        response = self.app.delete('/v1/orm/groups/{group id}/users/{user_id}/{domain}',
                                   expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 500)

    def test_delete_default_user_fail_bad_request(self):
        # given
        requests.delete = mock.MagicMock()

        users.GroupLogic.return_error = 2
        users.err_utils.get_error = mock.MagicMock(
            return_value=ClientSideError("blabla", 404))

        # when
        response = self.app.delete('/v1/orm/groups/{group id}/users/{user_id}/{domain}',
                                   expect_errors=True)

        # assert
        self.assertEqual(response.status_int, 404)


def get_mock_group_logic():
    global group_logic_mock
    group_logic_mock = mock.MagicMock()

    if users.GroupLogic.return_error == 0:
        res = GroupModels.UserResultWrapper(transaction_id='1',
                                            users=[],
                                            links={},
                                            created='1')

        group_logic_mock.add_group_default_users.return_value = res

    elif users.GroupLogic.return_error == 1:
        group_logic_mock.add_group_default_users.side_effect = SystemError()
        group_logic_mock.delete_group_default_user.side_effect = SystemError()

    else:
        group_logic_mock.add_group_default_users.side_effect = ErrorStatus(
            status_code=404)
        group_logic_mock.delete_group_default_user.side_effect = ErrorStatus(
            status_code=404)

    return group_logic_mock


class ResponseMock:
    def __init__(self, status_code=200):
        self.status_code = status_code


GROUPS_USER_JSON = [
    {
        "id": ["attuser1"],
        "domain": "nc"
    }
]
