"""unittests create group yaml module."""
from mock import patch
import unittest
import yaml

from orm.services.resource_distributor.rds.services import\
    yaml_group_builder as GroupBuild

alldata = {
    'description': 'this is a description', 'enabled': 1,
    'domain_name': 'groupdomain',
    "regions": [{
        "action": "modify",
        "name": "local",
        "users": []}],
    'name': 'test_group'}

region_nousers = {'name': 'regionname',
                  'rangerAgentVersion': 1.0,
                  'users': []}

region_users = {'name': 'regionname',
                'rangerAgentVersion': 1.0,
                'users': [{'id': ['user1', 'user2'], 'domain': 'domain1'}]}

yaml_group_nousers = \
    'heat_template_version: 2015-1-1\n\ndescription: yaml file for region - ' \
    'regionname\n\nresources:\n' \
    '  test_group:\n    properties:\n' \
    '      description: "this is a description"\n' \
    '      domain: groupdomain\n' \
    '      name: test_group\n' \
    '    type: OS::Keystone::Group\n\n\n' \
    'outputs:\n  test_group_id:\n    value: {get_resource: test_group}\n'

yaml_group_users = \
    'heat_template_version: 2015-1-1\n\ndescription: yaml file for region - ' \
    'regionname\n\nresources:\n' \
    '  test_group:\n    properties:\n' \
    '      description: "this is a description"\n' \
    '      domain: groupdomain\n' \
    '      name: test_group\n' \
    '    type: OS::Keystone::Group\n\n\n' \
    '  test_group_user_assignments:\n    properties:\n' \
    '      group: {get_resource: test_group}\n' \
    '      group_domain: groupdomain\n' \
    '      users:\n      - name: user1\n        user_domain: domain1\n' \
    '      - name: user2\n        user_domain: domain1\n' \
    '      group_domain: groupdomain\n' \
    '    type: OS::Keystone::GroupUserAssignment\n'\
    '\n\noutputs:\n  test_group_id:\n    value: {get_resource: test_group}\n' \
    '  test_group_user_assignments_id:\n    value: {get_resource: test_group_user_assignments}\n'


class CreateResource(unittest.TestCase):
    """class metohd."""
    maxDiff = None

    @patch.object(GroupBuild, 'conf')
    def test_create_group_yaml_nousers(self, mock_conf):
        """test valid dict to yaml output as expected without users."""
        ver = mock_conf.yaml_configs.group_yaml.yaml_version = '2015-1-1'
        yamlfile = GroupBuild.yamlbuilder(alldata, region_nousers)
        yamlfile_as_json = yaml.safe_load(yamlfile)
        self.assertEqual(yamlfile_as_json['heat_template_version'], ver)
        self.assertEqual(yaml.safe_load(yamlfile), yaml.safe_load(yaml_group_nousers))

    @patch.object(GroupBuild, 'conf')
    def test_create_group_yaml_users(self, mock_conf):
        """test valid dict to yaml output as expected without users."""
        ver = mock_conf.yaml_configs.group_yaml.yaml_version = '2015-1-1'
        yamlfile = GroupBuild.yamlbuilder(alldata, region_users)
        yamlfile_as_json = yaml.safe_load(yamlfile)
        self.assertEqual(yamlfile_as_json['heat_template_version'], ver)
        self.assertEqual(yaml.safe_load(yamlfile), yaml.safe_load(yaml_group_users))
